/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;

public class Measures
extends Shape {
    private static final int measurementGrowthIncrement = 16;
    private BitSet bsColixSet;
    private BitSet bsSelected;
    private String strFormat;
    private boolean isAllConnected = false;
    private float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
    private Atom[] atoms;
    private int atomCount;
    int measurementCount = 0;
    Measurement[] measurements = new Measurement[16];
    MeasurementPending measurementPending;
    short mad = (short)-1;
    short colix;
    Font3D font3d;

    protected void initModelSet() {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.measurements[i].modelSet = this.modelSet;
        }
        this.atoms = this.modelSet.atoms;
        this.atomCount = this.modelSet.getAtomCount();
    }

    public void initShape() {
        super.initShape();
        this.font3d = this.g3d.getFont3D(15.0f);
    }

    public void setSize(int n, BitSet bitSet) {
        this.mad = (short)n;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("select".equals(string)) {
            BitSet bitSet2 = (BitSet)object;
            if (bitSet2 == null || BitSetUtil.cardinalityOf(bitSet2) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BitSet();
                this.bsSelected.or(bitSet2);
            }
            return;
        }
        if ("color".equals(string)) {
            short s;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short s2 = s = object == null ? (short)0 : Graphics3D.getColix(object);
            if (this.bsSelected == null) {
                this.colix = s;
            }
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null || (this.bsSelected == null || !this.bsSelected.get(i)) && (this.bsSelected != null || s != 0 && this.measurements[i].getColix() != 0)) continue;
                this.measurements[i].setColix(s);
                this.bsColixSet.set(i);
            }
            return;
        }
        if ("refresh".equals(string)) {
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null) continue;
                this.measurements[i].refresh();
            }
            return;
        }
        if ("refreshTrajectories".equals(string)) {
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null || !this.measurements[i].isTrajectory()) continue;
                this.measurements[i].refresh();
            }
            return;
        }
        if ("hideAll".equals(string)) {
            this.showHide((Boolean)object);
            return;
        }
        if ("setFormats".equals(string)) {
            this.setFormats((String)object);
            return;
        }
        if ("delete".equals(string)) {
            this.delete(object);
            this.setIndices();
            return;
        }
        if ("clearModelIndex".equals(string)) {
            for (int i = 0; i < this.measurementCount; ++i) {
                this.measurements[i].setModelIndex((short)0);
            }
            return;
        }
        this.bsSelected = null;
        if ("pending".equals(string)) {
            this.pending((MeasurementPending)object);
        } else if ("font".equals(string)) {
            this.font3d = (Font3D)object;
        } else if ("clear".equals(string)) {
            this.clear();
        } else if ("reformatDistances".equals(string)) {
            this.reformatDistances();
        } else if ("setRange".equals(string)) {
            this.setRange((float[])object);
        } else if ("setFormat".equals(string)) {
            this.strFormat = (String)object;
        } else if ("setConnected".equals(string)) {
            this.setConnected((Boolean)object);
        } else if ("hide".equals(string)) {
            this.showHide(new Measurement(this.modelSet, (int[])object, null), true);
        } else if ("show".equals(string)) {
            this.showHide(new Measurement(this.modelSet, (int[])object, null), false);
        } else if ("toggle".equals(string)) {
            this.toggle(new Measurement(this.modelSet, (int[])object, null));
        } else if ("toggleOn".equals(string)) {
            this.toggleOn((int[])object);
        } else if ("hideVector".equals(string)) {
            this.showHide(this.setSingleItem((Vector)object), true);
        } else if ("showVector".equals(string)) {
            this.showHide(this.setSingleItem((Vector)object), false);
        } else if ("defineVector".equals(string)) {
            this.toggle(this.setSingleItem((Vector)object));
        } else if ("deleteVector".equals(string)) {
            this.define(this.setSingleItem((Vector)object), true, false, false);
            this.setIndices();
        } else if ("defineVector_All".equals(string)) {
            this.define((Vector)object, false, false, false);
        } else if ("deleteVector_All".equals(string)) {
            this.define((Vector)object, true, false, false);
            this.setIndices();
        } else if ("hideVector_All".equals(string)) {
            this.define((Vector)object, false, false, true);
        } else if ("showVector_All".equals(string)) {
            this.define((Vector)object, false, true, false);
        } else if ("deleteModelAtoms".equals(string)) {
            this.atoms = (Atom[])((Object[])object)[1];
            this.atomCount = this.modelSet.getAtomCount();
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = ((int[])((Object[])object)[2])[1];
            int n3 = ((int[])((Object[])object)[2])[2];
            int n4 = n2 + n3;
            int n5 = this.measurementCount;
            block4: while (--n5 >= 0) {
                Measurement measurement = this.measurements[n5];
                int[] nArray = measurement.getCountPlusIndices();
                for (int i = 1; i <= nArray[0]; ++i) {
                    int n6 = nArray[i];
                    if (n6 >= n2) {
                        if (n6 < n4) {
                            this.deleteMeasurement(n5);
                            continue block4;
                        }
                        int n7 = i;
                        nArray[n7] = nArray[n7] - n3;
                        continue;
                    }
                    if (n6 >= 0) continue;
                    Point3fi point3fi = measurement.getAtom(i);
                    if (point3fi.modelIndex > n) {
                        point3fi.modelIndex = (short)(point3fi.modelIndex - 1);
                        continue;
                    }
                    if (point3fi.modelIndex != n) continue;
                    this.deleteMeasurement(n5);
                    continue block4;
                }
            }
        }
    }

    private Measurement setSingleItem(Vector vector) {
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        nArray[0] = vector.size();
        int n = vector.size();
        while (--n >= 0) {
            Object e = vector.get(n);
            if (e instanceof BitSet) {
                int n2 = BitSetUtil.firstSetBit((BitSet)e);
                if (n2 < 0) {
                    return null;
                }
                nArray[n + 1] = n2;
                continue;
            }
            point3fiArray[n] = (Point3fi)e;
            nArray[n + 1] = -2 - n;
        }
        return new Measurement(this.modelSet, nArray, point3fiArray);
    }

    public Object getProperty(String string, int n) {
        if ("pending".equals(string)) {
            return this.measurementPending;
        }
        if ("count".equals(string)) {
            return new Integer(this.measurementCount);
        }
        if ("countPlusIndices".equals(string)) {
            return n < this.measurementCount ? this.measurements[n].getCountPlusIndices() : null;
        }
        if ("stringValue".equals(string)) {
            return n < this.measurementCount ? this.measurements[n].getString() : null;
        }
        if ("pointInfo".equals(string)) {
            return this.measurements[n / 10].getLabel(n % 10, false, false);
        }
        if ("info".equals(string)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(string)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    private void clear() {
        if (this.measurementCount == 0) {
            return;
        }
        int n = this.measurementCount;
        this.measurementCount = 0;
        int n2 = n;
        while (--n2 >= 0) {
            this.measurements[n2] = null;
        }
        this.viewer.setStatusMeasuring("measureDeleted", -1, "all");
    }

    private int findMeasurement(int[] nArray, Point3fi[] point3fiArray) {
        int n = this.measurementCount;
        while (--n >= 0) {
            if (!this.measurements[n].sameAs(nArray, point3fiArray)) continue;
            return n;
        }
        return -1;
    }

    private int findMeasurement(Measurement measurement) {
        return this.findMeasurement(measurement.getCountPlusIndices(), measurement.getPoints());
    }

    private void showHide(Measurement measurement, boolean bl) {
        int n = this.findMeasurement(measurement);
        if (n < 0) {
            return;
        }
        this.measurements[n].setHidden(bl);
    }

    private void showHide(boolean bl) {
        int n = this.measurementCount;
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            this.measurements[n].setHidden(bl);
        }
    }

    private void toggle(Measurement measurement) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        int n = this.findMeasurement(measurement);
        if (n >= 0 && !this.measurements[n].isHidden()) {
            this.define(this.measurements[n], true, false, false);
        } else {
            this.define(measurement, false, true, false);
        }
        this.setIndices();
    }

    private void toggleOn(int[] nArray) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        this.bsSelected = new BitSet();
        this.define(new Measurement(this.modelSet, nArray, null), false, true, true);
        this.setIndices();
        this.reformatDistances();
    }

    private void delete(Object object) {
        if (object instanceof int[]) {
            this.define(new Measurement(this.modelSet, (int[])object, null), true, false, false);
            return;
        }
        if (object instanceof Integer) {
            this.deleteMeasurement((Integer)object);
        }
    }

    private void define(Vector vector, boolean bl, boolean bl2, boolean bl3) {
        int n = vector.size();
        if (n < 2) {
            return;
        }
        int n2 = -1;
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        Measurement measurement = new Measurement(this.modelSet, nArray, point3fiArray);
        measurement.setCount(n);
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            Object e = vector.get(i);
            if (e instanceof BitSet) {
                BitSet bitSet = (BitSet)e;
                if (BitSetUtil.cardinalityOf(bitSet) > 1) {
                    n2 = 0;
                }
                n3 = i;
                nArray[i + 1] = BitSetUtil.firstSetBit(bitSet);
                continue;
            }
            if (point3fiArray == null) {
                point3fiArray = new Point3fi[4];
            }
            point3fiArray[i] = (Point3fi)e;
            nArray[i + 1] = -2 - i;
        }
        this.nextMeasure(0, n3, vector, measurement, n2, bl, bl2, bl3);
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            this.measurements[i].setIndex(i);
        }
    }

    private void define(Measurement measurement, boolean bl, boolean bl2, boolean bl3) {
        if (this.viewer.getMeasureAllModelsFlag()) {
            if (bl2) {
                this.define(measurement, true, false, false);
                if (bl) {
                    return;
                }
            }
            Vector<Point3fi> vector = new Vector<Point3fi>();
            int n = measurement.getCount();
            for (int i = 1; i <= n; ++i) {
                int n2 = measurement.getAtomIndex(i);
                vector.addElement((Point3fi)(n2 >= 0 ? this.viewer.getAtomBits(0x1500001, new Integer(this.atoms[n2].getAtomNumber())) : measurement.getAtom(i)));
            }
            this.define(vector, bl, false, false);
            return;
        }
        this.define(measurement, bl, bl3);
    }

    private void define(Measurement measurement, boolean bl, boolean bl2) {
        float f;
        int n = this.findMeasurement(measurement);
        int n2 = measurement.getCount();
        if (n < 0 && bl || measurement.sameAs(1, 2) || n2 > 2 && measurement.sameAs(1, 3) || n2 == 4 && measurement.sameAs(2, 4)) {
            return;
        }
        float f2 = f = bl ? this.rangeMinMax[0] : measurement.getMeasurement();
        if (this.rangeMinMax[0] != Float.MAX_VALUE && (f < this.rangeMinMax[0] || f > this.rangeMinMax[1])) {
            return;
        }
        if (n >= 0) {
            if (bl) {
                this.deleteMeasurement(n);
            } else {
                this.measurements[n].setHidden(false);
                if (bl2) {
                    this.bsSelected.set(n);
                }
            }
            return;
        }
        Measurement measurement2 = new Measurement(this.modelSet, measurement.getCountPlusIndices(), measurement.getPoints(), f, this.colix, this.strFormat, this.measurementCount);
        if (this.measurementCount == this.measurements.length) {
            this.measurements = (Measurement[])ArrayUtil.setLength(this.measurements, this.measurementCount + 16);
        }
        int n3 = this.measurementCount;
        this.measurements[this.measurementCount++] = measurement2;
        this.viewer.setStatusMeasuring("measureCompleted", n3, measurement2.toVector().toString());
    }

    private void deleteMeasurement(int n) {
        String string = this.measurements[n].toVector().toString();
        System.arraycopy(this.measurements, n + 1, this.measurements, n, this.measurementCount - n - 1);
        this.measurements[--this.measurementCount] = null;
        this.viewer.setStatusMeasuring("measureDeleted", n, string);
    }

    private void nextMeasure(int n, int n2, Vector vector, Measurement measurement, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (n > n2) {
            if (this.isAllConnected && !this.isConnected(measurement, n)) {
                return;
            }
            int n4 = this.findMeasurement(measurement);
            if (n4 >= 0) {
                if (bl) {
                    this.define(measurement, true, false);
                } else if (this.strFormat != null) {
                    this.measurements[n4].formatMeasurement(this.strFormat, true);
                } else {
                    this.measurements[n4].setHidden(bl3);
                }
            } else if (!(bl || bl3 || bl2)) {
                this.define(measurement, false, true);
            }
            return;
        }
        BitSet bitSet = (BitSet)vector.get(n);
        int[] nArray = measurement.getCountPlusIndices();
        int n5 = nArray[n];
        if (n5 < 0) {
            this.nextMeasure(n + 1, n2, vector, measurement, n3, bl, bl2, bl3);
            return;
        }
        boolean bl4 = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i) || i == n5) continue;
            int n6 = this.atoms[i].getModelIndex();
            if (n3 >= 0) {
                if (n == 0) {
                    n3 = n6;
                } else if (n3 != n6) continue;
            }
            nArray[n + 1] = i;
            bl4 = true;
            this.nextMeasure(n + 1, n2, vector, measurement, n3, bl, bl2, bl3);
        }
        if (!bl4) {
            this.nextMeasure(n + 1, n2, vector, measurement, n3, bl, bl2, bl3);
        }
    }

    private boolean isConnected(Measurement measurement, int n) {
        int n2 = -1;
        for (int i = 1; i <= n; ++i) {
            int n3 = measurement.getAtomIndex(i);
            if (n3 < 0) continue;
            if (n2 >= 0 && !this.atoms[n3].isBonded(this.atoms[n2])) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    private void setRange(float[] fArray) {
        this.rangeMinMax[0] = fArray[0];
        this.rangeMinMax[1] = fArray[1];
    }

    private void setConnected(boolean bl) {
        this.isAllConnected = bl;
    }

    private void pending(MeasurementPending measurementPending) {
        this.measurementPending = measurementPending;
        if (measurementPending == null) {
            return;
        }
        if (measurementPending.getCount() > 1) {
            this.viewer.setStatusMeasuring("measurePending", measurementPending.getCount(), measurementPending.toVector().toString());
        }
    }

    private void reformatDistances() {
        int n = this.measurementCount;
        while (--n >= 0) {
            this.measurements[n].reformatDistanceIfSelected();
        }
    }

    private void setFormats(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        int n = this.measurementCount;
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            this.measurements[n].formatMeasurement(string, false);
        }
    }

    private Vector getAllInfo() {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.measurementCount; ++i) {
            vector.addElement(this.getInfo(i));
        }
        return vector;
    }

    private String getAllInfoAsString() {
        String string = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            string = string + "\n" + this.getInfoAsString(i);
        }
        return string;
    }

    private Hashtable getInfo(int n) {
        Measurement measurement = this.measurements[n];
        int n2 = measurement.getCount();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("index", new Integer(n));
        hashtable.put("type", n2 == 2 ? "distance" : (n2 == 3 ? "angle" : "dihedral"));
        hashtable.put("strMeasurement", measurement.getString());
        hashtable.put("count", new Integer(n2));
        hashtable.put("value", new Float(measurement.getValue()));
        Vector vector = new Vector();
        for (int i = 1; i <= n2; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            int n3 = measurement.getAtomIndex(i);
            hashtable2.put("_ipt", new Integer(n3));
            hashtable2.put("coord", Escape.escape(measurement.getAtom(i)));
            hashtable2.put("atomno", new Integer(n3 < 0 ? -1 : this.atoms[n3].getAtomNumber()));
            hashtable2.put("info", n3 < 0 ? "<point>" : this.atoms[n3].getInfo());
            vector.addElement(hashtable2);
        }
        hashtable.put("atoms", vector);
        return hashtable;
    }

    private String getInfoAsString(int n) {
        Measurement measurement = this.measurements[n];
        int n2 = measurement.getCount();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 == 2 ? "distance" : (n2 == 3 ? "angle" : "dihedral"));
        stringBuffer.append(" \t").append(measurement.getValue()).append(" \t").append(measurement.getString());
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(" \t").append(measurement.getLabel(i, false, false));
        }
        return stringBuffer.toString();
    }

    void setVisibilityInfo() {
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        int n = this.measurementCount;
        block0: while (--n >= 0) {
            Measurement measurement = this.measurements[n];
            measurement.setVisible(false);
            if (this.mad == 0 || measurement.isHidden()) continue;
            for (int i = measurement.getCount(); i > 0; --i) {
                short s;
                int n2 = measurement.getAtomIndex(i);
                if (n2 >= 0 ? !this.modelSet.getAtomAt(n2).isClickable() : (s = measurement.getAtom((int)i).modelIndex) >= 0 && !bitSet.get(s)) continue block0;
            }
            this.measurements[n].setVisible(true);
        }
    }

    public String getShapeState() {
        String string;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        Shape.appendCmd(stringBuffer, "measures delete");
        for (n2 = 0; n2 < this.measurementCount; ++n2) {
            Shape.appendCmd(stringBuffer, this.getState(n2));
        }
        Shape.appendCmd(stringBuffer, "select *; set measures " + this.viewer.getMeasureDistanceUnits());
        Shape.appendCmd(stringBuffer, Shape.getFontCommand("measures", this.font3d));
        n2 = 0;
        Hashtable hashtable = new Hashtable();
        BitSet bitSet = new BitSet(this.measurementCount);
        for (n = 0; n < this.measurementCount; ++n) {
            if (this.measurements[n].isHidden()) {
                ++n2;
                bitSet.set(n);
            }
            if (this.bsColixSet != null && this.bsColixSet.get(n)) {
                Shape.setStateInfo(hashtable, n, this.getColorCommand("measure", this.measurements[n].getColix()));
            }
            if (this.measurements[n].getStrFormat() == null) continue;
            Shape.setStateInfo(hashtable, n, "measure " + Escape.escape(this.measurements[n].getStrFormat()));
        }
        if (n2 > 0) {
            if (n2 == this.measurementCount) {
                Shape.appendCmd(stringBuffer, "measures off; # lines and numbers off");
            } else {
                for (n = 0; n < this.measurementCount; ++n) {
                    if (!this.measurements[n].isHidden()) continue;
                    Shape.setStateInfo(hashtable, n, "measure off");
                }
            }
        }
        if ((string = Shape.getShapeCommands(hashtable, null, -1, "select measures")) != null) {
            stringBuffer.append(string);
            Shape.appendCmd(stringBuffer, "select measures ({null})");
        }
        return stringBuffer.toString();
    }

    private String getState(int n) {
        Measurement measurement = this.measurements[n];
        int n2 = measurement.getCount();
        StringBuffer stringBuffer = new StringBuffer("measure");
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(" ").append(measurement.getLabel(i, true, true));
        }
        stringBuffer.append("; # " + this.getInfoAsString(n));
        return stringBuffer.toString();
    }
}

