/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.PeasyCam;

public abstract class DampedAction {
    private final PeasyCam p;
    private double velocity;
    final double dampening;

    public DampedAction(PeasyCam p) {
        this(p, 0.16);
    }

    public DampedAction(PeasyCam p, double friction) {
        this.p = p;
        this.velocity = 0.0;
        this.dampening = 1.0 - friction;
        p.getApplet().registerDraw((Object)this);
    }

    public void impulse(double impulse) {
        this.velocity += impulse;
    }

    public void draw() {
        if (this.velocity == 0.0) {
            return;
        }
        this.behave(this.velocity);
        this.p.feed();
        this.velocity *= this.dampening;
        if (Math.abs(this.velocity) < 0.001) {
            this.velocity = 0.0;
        }
    }

    public void stop() {
        this.velocity = 0.0;
    }

    protected abstract void behave(double var1);
}

