/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.Vector3D;

public class InterpolationUtil {
    public static Rotation slerp(Rotation a, Rotation b, double t) {
        double w2;
        double w1;
        double cosTheta = a.getQ0() * b.getQ0() + a.getQ1() * b.getQ1() + a.getQ2() * b.getQ2() + a.getQ3() * b.getQ3();
        double theta = Math.acos(cosTheta);
        double sinTheta = Math.sin(theta);
        if (sinTheta > (double)0.001f) {
            w1 = Math.sin((1.0 - t) * theta) / sinTheta;
            w2 = Math.sin(t * theta) / sinTheta;
        } else {
            w1 = 1.0 - t;
            w2 = t;
        }
        return new Rotation(w1 * a.getQ0() + w2 * b.getQ0(), w1 * a.getQ1() + w2 * b.getQ1(), w1 * a.getQ2() + w2 * b.getQ2(), w1 * a.getQ3() + w2 * b.getQ3(), true);
    }

    public static double smooth(double a, double b, double t) {
        double smooth = t * t * (3.0 - 2.0 * t);
        return b * smooth + a * (1.0 - smooth);
    }

    public static Vector3D smooth(Vector3D a, Vector3D b, double t) {
        return new Vector3D(InterpolationUtil.smooth(a.getX(), b.getX(), t), InterpolationUtil.smooth(a.getY(), b.getY(), t), InterpolationUtil.smooth(a.getZ(), b.getZ(), t));
    }

    public static double linear(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static Vector3D linear(Vector3D a, Vector3D b, double t) {
        return new Vector3D(InterpolationUtil.linear(a.getX(), b.getX(), t), InterpolationUtil.linear(a.getY(), b.getY(), t), InterpolationUtil.linear(a.getZ(), b.getZ(), t));
    }
}

