/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    String header = "";
    private static final String isotopeMap0 = "H1 H2 ";
    private static final String isotopeMap1 = "D  T  ";

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.atomSetCollection = new AtomSetCollection("mol");
        this.reader = bufferedReader;
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("$MDL")) {
                    this.processRgHeader();
                    this.discardLinesUntilStartsWith("$CTAB");
                    this.processCtab();
                } else if (this.doGetModel(++this.modelNumber)) {
                    this.processMolSdHeader();
                    this.processCtab();
                    if (this.isLastModel(this.modelNumber)) break;
                }
                this.flushLines();
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    void processMolSdHeader() throws Exception {
        String string = this.line;
        this.header = this.header + this.line + "\n";
        this.atomSetCollection.setCollectionName(this.line);
        this.readLine();
        if (this.line == null) {
            return;
        }
        this.header = this.header + this.line + "\n";
        this.readLine();
        if (this.line == null) {
            return;
        }
        this.header = this.header + this.line + "\n";
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", (Object)this.header);
        this.newAtomSet(string);
    }

    void processRgHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$HDR")) {
        }
        if (this.line == null) {
            Logger.warn((String)"$HDR not found in MDL RG file");
            return;
        }
        this.readLine();
        this.processMolSdHeader();
    }

    void processCtab() throws Exception {
        this.readLine();
        if (this.line == null) {
            return;
        }
        int n = this.parseInt(this.line, 0, 3);
        int n2 = this.parseInt(this.line, 3, 6);
        int n3 = this.atomSetCollection.getAtomCount();
        this.readAtoms(n);
        this.readBonds(n3, n2);
        this.applySymmetryAndSetTrajectory();
    }

    void flushLines() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$")) {
        }
    }

    void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
            String string = "";
            string = this.line.length() > 34 ? this.line.substring(31, 34).trim().intern() : this.line.substring(31).trim().intern();
            float f = this.parseFloat(this.line, 0, 10);
            float f2 = this.parseFloat(this.line, 10, 20);
            float f3 = this.parseFloat(this.line, 20, 30);
            int n2 = 0;
            if (this.line.length() >= 39) {
                int n3 = this.parseInt(this.line, 36, 39);
                if (n3 >= 1 && n3 <= 7) {
                    n2 = 4 - n3;
                }
                if ((n3 = this.parseInt(this.line, 34, 36)) != 0 && n3 >= -3 && n3 <= 4) {
                    int n4 = isotopeMap0.indexOf(string + n3);
                    if (n4 >= 0) {
                        string = isotopeMap1.substring(n4, n4 + 3).trim();
                    } else if (string == "C") {
                        string = 12 + n3 + "C";
                    } else if (string == "N") {
                        string = 14 + n3 + "N";
                    }
                }
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.formalCharge = n2;
            this.setAtomCoord(atom, f, f2, f3);
        }
    }

    void readBonds(int n, int n2) throws Exception {
        for (int i = 0; i < n2; ++i) {
            this.readLine();
            int n3 = this.parseInt(this.line, 0, 3);
            int n4 = this.parseInt(this.line, 3, 6);
            int n5 = this.parseInt(this.line, 6, 9);
            switch (n5) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    n5 = 515;
                    break;
                }
                case 5: {
                    n5 = 66;
                    break;
                }
                case 6: {
                    n5 = 513;
                    break;
                }
                case 7: {
                    n5 = 514;
                    break;
                }
                case 8: {
                    n5 = 33;
                }
            }
            this.atomSetCollection.addBond(new Bond(n + n3 - 1, n + n4 - 1, n5));
        }
    }
}

