/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class GromacsReader
extends AtomSetCollectionReader {
    protected String fileType = "gromacs";

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("xyz");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", (Object)Boolean.TRUE);
        try {
            this.readAtomSetName();
            int n = this.readAtomCount();
            this.readAtoms(n);
            this.applySymmetryAndSetTrajectory();
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    private int readAtomCount() throws Exception {
        int n;
        this.readLine();
        if (this.line != null && (n = this.parseInt(this.line)) > 0) {
            return n;
        }
        return 0;
    }

    private void readAtomSetName() throws Exception {
        this.readLineTrimmed();
        this.checkLineForScript();
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.line);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", (Object)Boolean.TRUE);
    }

    private void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.readLine();
            if (this.line.length() < 68) {
                Logger.warn((String)("line cannot be read for GROMACS atom data: " + this.line));
                continue;
            }
            Atom atom = new Atom();
            atom.sequenceNumber = this.parseInt(this.line, 0, 5);
            atom.group3 = this.parseToken(this.line, 5, 9).trim();
            atom.atomName = this.line.substring(11, 15).trim();
            atom.atomSerial = this.parseInt(this.line, 15, 20);
            atom.x = this.parseFloat(this.line, 20, 28) * 10.0f;
            atom.y = this.parseFloat(this.line, 28, 36) * 10.0f;
            atom.z = this.parseFloat(this.line, 36, 44) * 10.0f;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn((String)("line cannot be read for GROMACS atom data: " + this.line));
                atom.set(0.0f, 0.0f, 0.0f);
            }
            this.setAtomCoord(atom);
            atom.elementSymbol = this.deduceElementSymbol(atom.group3, atom.atomName);
            if (this.filter != null && !this.filterAtom(atom)) continue;
            atom.isHetero = false;
            this.atomSetCollection.addAtom(atom);
            float f = this.parseFloat(this.line, 44, 52) * 10.0f;
            float f2 = this.parseFloat(this.line, 52, 60) * 10.0f;
            float f3 = this.parseFloat(this.line, 60, 68) * 10.0f;
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue;
            atom.vectorX = f;
            atom.vectorY = f2;
            atom.vectorZ = f3;
        }
    }

    String deduceElementSymbol(String string, String string2) {
        if (string2.length() <= 2 && string.equals(string2)) {
            return string2;
        }
        char c = string2.length() == 4 ? string2.charAt(0) : (char)'\u0000';
        char c2 = string2.charAt(string2.length() == 4 ? 1 : 0);
        boolean bl = JmolConstants.isHetero((String)string);
        if (Atom.isValidElementSymbolNoCaseSecondChar((char)c, (char)c2)) {
            return bl || c != 'H' ? "" + c + c2 : "H";
        }
        if (Atom.isValidElementSymbol((char)c2)) {
            return "" + c2;
        }
        if (Atom.isValidElementSymbol((char)c)) {
            return "" + c;
        }
        return "Xx";
    }
}

