/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

abstract class MOReader
extends AtomSetCollectionReader {
    protected int shellCount = 0;
    protected int gaussianCount = 0;
    protected Hashtable moData = new Hashtable();
    protected Vector shells;
    protected float[][] gaussians;
    protected Vector orbitals = new Vector();
    protected String energyUnits = "";
    protected Vector moTypes;
    private boolean getNBOs;
    private boolean getNBOCharges;
    protected boolean haveNboCharges;
    private String[] filterTokens;
    private boolean filterIsNot;
    protected boolean iHaveAtoms = false;
    protected boolean continuing = true;
    protected boolean ignoreMOs = false;
    protected String alphaBeta = "";
    protected final int HEADER_GAMESS_UK_MO = 3;
    protected final int HEADER_GAMESS_OCCUPANCIES = 2;
    protected final int HEADER_GAMESS_ORIGINAL = 1;
    protected final int HEADER_NONE = 0;

    MOReader() {
    }

    public abstract void readAtomSetCollection(BufferedReader var1);

    protected abstract boolean checkLine() throws Exception;

    public void readAtomSetCollection(BufferedReader bufferedReader, String string) {
        this.initializeMoReader(bufferedReader, string);
        try {
            this.readLine();
            this.iHaveAtoms = false;
            while (this.line != null && this.continuing) {
                if (!this.checkLine()) continue;
                this.readLine();
            }
            this.finalizeMoReader();
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    protected void finalizeMoReader() {
    }

    private void initializeMoReader(BufferedReader bufferedReader, String string) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection(string);
        this.line = "\nNBOs in the AO basis:";
        this.getNBOs = this.filterMO();
        this.line = "\nNBOcharges";
        boolean bl = this.getNBOCharges = this.filter != null && this.filterMO();
        if (this.filter == null) {
            return;
        }
        this.filter = TextFormat.simpleReplace((String)this.filter, (String)"nbocharges", (String)"");
        if (this.filter.length() < 3) {
            this.filter = null;
        }
    }

    protected boolean filterMO() {
        if (this.filter == null) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        this.line = this.line.toLowerCase() + " " + this.alphaBeta;
        if (this.filterTokens == null) {
            this.filterIsNot = this.filter.indexOf("!") >= 0;
            this.filterTokens = AtomSetCollectionReader.getTokens((String)this.filter.replace('!', ' ').replace(',', ' ').replace(';', ' ').toLowerCase());
        }
        for (int i = 0; i < this.filterTokens.length; ++i) {
            if (this.line.indexOf(this.filterTokens[i]) >= 0) {
                if (this.filterIsNot) continue;
                n = this.filterTokens.length;
                break;
            }
            if (!this.filterIsNot) continue;
            ++n;
        }
        boolean bl2 = bl = n == this.filterTokens.length;
        if (this.line.indexOf(10) != 0) {
            Logger.info((String)("filter MOs: " + bl + " for \"" + this.line + "\""));
        }
        return bl;
    }

    protected boolean checkNboLine() throws Exception {
        if (this.getNBOs) {
            if (this.line.indexOf("(Occupancy)   Bond orbital/ Coefficients/ Hybrids") >= 0) {
                this.getNboTypes();
                return false;
            }
            if (this.line.indexOf("NBOs in the AO basis:") >= 0) {
                this.readMolecularOrbitals(0);
                return false;
            }
        }
        if (this.getNBOCharges && this.line.indexOf("Summary of Natural Population Analysis:") >= 0) {
            this.getNboCharges();
            return true;
        }
        return true;
    }

    private void getNboCharges() throws Exception {
        if (this.haveNboCharges) {
            return;
        }
        this.discardLinesUntilContains("----");
        this.discardLinesUntilContains("----");
        this.haveNboCharges = true;
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            float f;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            String[] stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
            if (stringArray == null || stringArray.length < 3 || Float.isNaN(f = this.parseFloat(stringArray[2]))) {
                Logger.info((String)("Error reading NBO charges: " + this.line));
                return;
            }
            atomArray[i].partialCharge = f;
            if (!Logger.debugging) continue;
            Logger.debug((String)("Atom " + i + " using NBOcharge: " + f));
        }
        Logger.info((String)("Using NBO charges for Model " + this.atomSetCollection.getAtomSetCount()));
    }

    protected void getNboTypes() throws Exception {
        this.moTypes = new Vector();
        this.readLine();
        this.readLine();
        int n = 0;
        while (this.line != null && this.line.indexOf(".") == 4 && this.parseInt(this.line.substring(0, 4)) == n + 1) {
            this.moTypes.add(n++, this.line.substring(5, 34).trim());
            while (this.readLine() != null && this.line.startsWith("     ")) {
            }
        }
        Logger.info((String)(n + " natural bond orbitals read"));
    }

    protected void readMolecularOrbitals(int n) throws Exception {
        if (this.ignoreMOs) {
            this.readLine();
            return;
        }
        Hashtable[] hashtableArray = null;
        Vector[] vectorArray = null;
        Vector<String> vector = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.readLine();
        int n5 = 0;
        int n6 = -1;
        boolean bl = false;
        if (this.line.indexOf("---") >= 0) {
            this.readLine();
        }
        while (this.readLine() != null) {
            int n7;
            String[] stringArray = this.getTokens();
            if (Logger.debugging) {
                Logger.debug((String)(stringArray.length + " --- " + this.line));
            }
            if (this.line.indexOf("end") >= 0) break;
            if (this.line.indexOf(" ALPHA SET ") >= 0) {
                this.alphaBeta = "alpha";
                if (this.readLine() == null) {
                    break;
                }
            } else if (this.line.indexOf(" BETA SET ") >= 0) {
                if (bl) break;
                this.alphaBeta = "beta";
                if (this.readLine() == null) break;
            }
            if (this.line.length() == 0 || this.line.indexOf("--") >= 0 || this.line.indexOf(".....") >= 0 || this.line.indexOf("NBO BASIS") >= 0 || this.line.indexOf("CI EIGENVECTORS WILL BE LABELED") >= 0 || this.line.indexOf("   THIS LOCALIZATION HAD") >= 0) {
                for (n7 = 0; n7 < n4; ++n7) {
                    float[] fArray = new float[vectorArray[n7].size()];
                    int n8 = 0;
                    while (n8 < fArray.length) {
                        if (((String)vector.get(n8)).equals("XXX")) {
                            int n9;
                            Hashtable hashtable = new Hashtable();
                            for (n9 = 0; n9 < 10; ++n9) {
                                hashtable.put(vector.get(n8 + n9), vectorArray[n7].get(n8 + n9));
                            }
                            for (n9 = 0; n9 < 10; ++n9) {
                                String string = JmolAdapter.getQuantumSubshellTag((int)5, (int)n9);
                                fArray[n8++] = this.parseFloat((String)hashtable.get(string));
                            }
                            continue;
                        }
                        fArray[n8] = this.parseFloat((String)vectorArray[n7].get(n8));
                        ++n8;
                    }
                    bl = true;
                    hashtableArray[n7].put("coefficients", fArray);
                    if (this.alphaBeta.length() > 0) {
                        hashtableArray[n7].put("type", this.alphaBeta);
                    } else if (this.moTypes != null && n5 < this.moTypes.size()) {
                        hashtableArray[n7].put("type", this.moTypes.get(n5++));
                    }
                    this.orbitals.addElement(hashtableArray[n7]);
                }
                n4 = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            if (n4 == 0) {
                n4 = stringArray.length;
                if (stringArray[0].equals("AO")) {
                    --n4;
                    n2 = 16;
                    n3 = 8;
                    n6 = 3;
                }
                if (hashtableArray == null || n4 > hashtableArray.length) {
                    hashtableArray = new Hashtable[n4];
                    vectorArray = new Vector[n4];
                }
                for (n7 = 0; n7 < n4; ++n7) {
                    hashtableArray[n7] = new Hashtable();
                    vectorArray[n7] = new Vector();
                }
                this.getMOHeader(n, stringArray, hashtableArray, n4);
                vector = new Vector<String>();
                continue;
            }
            if (n2 < 0) {
                n6 = stringArray.length - n4;
                for (n7 = 0; n7 < n4; ++n7) {
                    vectorArray[n7].addElement(stringArray[n7 + n6]);
                }
            } else {
                n7 = n2;
                int n10 = 0;
                while (n10 < n4) {
                    vectorArray[n10].addElement(this.line.substring(n7, n7 + n3).trim());
                    ++n10;
                    n7 += n3;
                }
            }
            vector.addElement(JmolAdapter.canonicalizeQuantumSubshellTag((String)stringArray[n6 - 1].toUpperCase()));
            this.line = "";
        }
        this.energyUnits = "a.u.";
        this.setMOData(!this.alphaBeta.equals("alpha"));
    }

    protected void getMOHeader(int n, String[] stringArray, Hashtable[] hashtableArray, int n2) throws Exception {
        int n3;
        this.readLine();
        switch (n) {
            default: {
                for (int i = 0; i < n2; ++i) {
                    hashtableArray[i].put("energy", "");
                }
                return;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    hashtableArray[i].put("energy", new Float(stringArray[i]));
                }
                this.discardLines(5);
                return;
            }
            case 1: {
                stringArray = this.getTokens();
                if (stringArray.length == 0) {
                    stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    hashtableArray[n3].put("energy", new Float(stringArray[n3]));
                }
                this.readLine();
                break;
            }
            case 2: {
                n3 = this.line.length() > 0 || this.readLine() != null ? 1 : 0;
                stringArray = this.getTokens();
                for (int i = 0; i < n2; ++i) {
                    hashtableArray[i].put("occupancy", new Float(stringArray[i].charAt(0) == '-' ? 2.0f : this.parseFloat(stringArray[i])));
                }
                this.readLine();
                if (n3 != 0) break;
                return;
            }
        }
        if (this.line.length() > 0) {
            stringArray = this.getTokens();
            for (n3 = 0; n3 < n2; ++n3) {
                hashtableArray[n3].put("symmetry", stringArray[n3]);
            }
        }
    }

    protected void addMOData(int n, Vector[] vectorArray, Hashtable[] hashtableArray) {
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[vectorArray[i].size()];
            int n2 = fArray.length;
            while (--n2 >= 0) {
                fArray[n2] = this.parseFloat((String)vectorArray[i].get(n2));
            }
            hashtableArray[i].put("coefficients", fArray);
            this.orbitals.addElement(hashtableArray[i]);
        }
    }

    protected void setMOData(boolean bl) {
        this.moData.put("calculationType", this.calculationType);
        this.moData.put("energyUnits", this.energyUnits);
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", this.gaussians);
        this.moData.put("mos", this.orbitals);
        this.setMOData(this.moData);
        if (bl) {
            this.orbitals = new Vector();
            this.moData = new Hashtable();
            this.alphaBeta = "";
        }
    }
}

