/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.readers.more.FFReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MdTopReader
extends FFReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    String[] group3s;

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mdtop");
        try {
            Atom atom;
            int n;
            this.setUserAtomTypes();
            this.readLine();
            while (this.line != null) {
                if (this.line.indexOf("%FLAG ") != 0) {
                    this.readLine();
                    continue;
                }
                this.line = this.line.substring(6).trim();
                if (this.line.equals("POINTERS")) {
                    this.getPointers();
                    continue;
                }
                if (this.line.equals("ATOM_NAME")) {
                    this.getAtomNames();
                    continue;
                }
                if (this.line.equals("CHARGE")) {
                    this.getCharges();
                    continue;
                }
                if (this.line.equals("RESIDUE_LABEL")) {
                    this.getResidueLabels();
                    continue;
                }
                if (this.line.equals("RESIDUE_POINTER")) {
                    this.getResiduePointers();
                    continue;
                }
                if (this.line.equals("AMBER_ATOM_TYPE")) {
                    this.getAtomTypes();
                    continue;
                }
                if (!this.line.equals("MASS")) continue;
                this.getMasses();
            }
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            if (this.filter == null) {
                this.nAtoms = this.atomCount;
            } else {
                Atom[] atomArray2 = new Atom[atomArray.length];
                this.nAtoms = 0;
                for (n = 0; n < this.atomCount; ++n) {
                    if (!this.filterAtom(atomArray[n], n)) continue;
                    atomArray2[this.nAtoms++] = atomArray[n];
                }
                this.atomSetCollection.discardPreviousAtoms();
                for (n = 0; n < this.nAtoms; ++n) {
                    atom = atomArray2[n];
                    this.atomSetCollection.addAtom(atom);
                }
            }
            Logger.info((String)("Total number of atoms used=" + this.nAtoms));
            int n2 = 0;
            for (n = 0; n < this.nAtoms; ++n) {
                atom = atomArray[n];
                if (n % 100 == 0) {
                    ++n2;
                }
                this.setAtomCoord(atom, n % 100 * 2, n2 * 2, 0.0f);
                atom.isHetero = JmolAdapter.isHetero((String)atom.group3);
                String string = atom.atomName;
                string = string.substring(string.indexOf(0) + 1);
                if (this.getElementSymbol(atom, string)) continue;
                atom.elementSymbol = AtomSetCollectionReader.deducePdbElementSymbol((boolean)atom.isHetero, (String)atom.atomName, (String)atom.group3);
            }
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", (Object)Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", (Object)Boolean.TRUE);
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    private String getDataBlock() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && this.line.indexOf("%FLAG") != 0) {
            stringBuffer.append(this.line);
        }
        return stringBuffer.toString();
    }

    private void getMasses() throws Exception {
    }

    private void getAtomTypes() throws Exception {
        this.readLine();
        String[] stringArray = AtomSetCollectionReader.getTokens((String)this.getDataBlock());
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomCount;
        while (--n >= 0) {
            atomArray[n].atomName = atomArray[n].atomName + '\u0000' + stringArray[n];
        }
    }

    private void getCharges() throws Exception {
        float[] fArray = new float[this.atomCount];
        this.readLine();
        AtomSetCollectionReader.getTokensFloat((String)this.getDataBlock(), (float[])fArray, (int)this.atomCount);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomCount;
        while (--n >= 0) {
            atomArray[n].partialCharge = fArray[n];
        }
    }

    private void getResiduePointers() throws Exception {
        this.readLine();
        String[] stringArray = AtomSetCollectionReader.getTokens((String)this.getDataBlock());
        Logger.info((String)("Total number of residues=" + stringArray.length));
        int n = this.atomCount;
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            int n3;
            int n4 = n3 = this.parseInt(stringArray[n2]) - 1;
            while (n4 < n) {
                if (this.group3s != null) {
                    atomArray[n4].group3 = this.group3s[n2];
                }
                atomArray[n4++].sequenceNumber = n2 + 1;
            }
            n = n3;
        }
    }

    private void getResidueLabels() throws Exception {
        this.readLine();
        this.group3s = AtomSetCollectionReader.getTokens((String)this.getDataBlock());
    }

    private void getAtomNames() throws Exception {
        this.readLine();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < this.atomCount) {
            if (n2 >= n3) {
                this.readLine();
                n2 = 0;
                n3 = this.line.length();
            }
            atomArray[n++].atomName = this.line.substring(n2, n2 + 4).trim();
            n2 += 4;
        }
    }

    private void getPointers() throws Exception {
        boolean bl;
        this.readLine();
        String string = "";
        int n = 0;
        while (n++ < 3 && (this.line = this.readLine()) != null && !this.line.startsWith("#")) {
            string = string + this.line;
        }
        String[] stringArray = AtomSetCollectionReader.getTokens((String)string);
        this.atomCount = this.parseInt(stringArray[0]);
        boolean bl2 = bl = stringArray[27].charAt(0) != '0';
        if (bl) {
            Logger.info((String)("Periodic type: " + stringArray[27]));
            this.htParams.put("isPeriodic", Boolean.TRUE);
        }
        Logger.info((String)("Total number of atoms read=" + this.atomCount));
        this.htParams.put("templateAtomCount", new Integer(this.atomCount));
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomSetCollection.addAtom(new Atom());
        }
    }
}

