/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;

public abstract class AtomSetCollectionReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    protected AtomSetCollection atomSetCollection;
    protected BufferedReader reader;
    protected String readerName;
    public Hashtable htParams;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    private long ptLine;
    public int[] latticeCells;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    protected boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    protected boolean applySymmetryToBonds;
    protected boolean needToApplySymmetry;
    protected boolean getHeader;
    protected int templateAtomCount;
    protected int modelNumber;
    protected BitSet bsModels;
    protected BitSet bsFilter;
    protected String filter;
    protected boolean haveAtomFilter;
    protected String spaceGroup;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    private boolean iHaveFractionalCoordinates;
    private boolean doPackUnitCell;
    private boolean doConvertToFractional;
    private boolean fileCoordinatesAreFractional;
    protected boolean ignoreFileUnitCell;
    private boolean ignoreFileSpaceGroupName;
    private float symmetryRange;
    private float[] notionalUnitCell;
    private int[] firstLastStep;
    private int desiredModelNumber = Integer.MIN_VALUE;
    private int lastModelNumber = Integer.MAX_VALUE;
    private int desiredSpaceGroupIndex = -1;
    private SymmetryInterface symmetry;
    private boolean haveModel = false;
    private int nMatrixElements = 0;
    private Matrix3f matrixRotate;
    private String previousScript;

    public Object readData(String string, Hashtable hashtable, BufferedReader bufferedReader) throws Exception {
        this.initialize(hashtable);
        this.readAtomSetCollection(bufferedReader);
        bufferedReader.close();
        return this.finalize(hashtable, string);
    }

    protected Object readData(String string, Hashtable hashtable, Object object) {
        this.initialize(hashtable);
        this.readAtomSetCollectionFromDOM(object);
        return this.finalize(hashtable, string);
    }

    public abstract void readAtomSetCollection(BufferedReader var1);

    public void readAtomSetCollectionFromDOM(Object object) {
    }

    private Object finalize(Hashtable hashtable, String string) {
        String string2;
        if (!hashtable.containsKey("templateAtomCount")) {
            hashtable.put("templateAtomCount", new Integer(this.atomSetCollection.getAtomCount()));
        }
        if (hashtable.containsKey("bsFilter")) {
            hashtable.put("filteredAtomCount", new Integer(BitSetUtil.cardinalityOf((BitSet)hashtable.get("bsFilter"))));
        }
        if (!this.calculationType.equals("?")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationType", this.calculationType);
        }
        if ((string2 = this.atomSetCollection.fileTypeName).indexOf("(") >= 0) {
            string2 = string2.substring(0, string2.indexOf("("));
        }
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileName", string, n);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileType", string2, n);
        }
        this.atomSetCollection.freeze();
        if (this.atomSetCollection.errorMessage != null) {
            return this.atomSetCollection.errorMessage + "\nfor file " + string + "\ntype " + this.atomSetCollection.fileTypeName;
        }
        if (this.atomSetCollection.atomCount == 0) {
            return "No atoms found\nfor file " + string + "\ntype " + this.atomSetCollection.fileTypeName;
        }
        return this.atomSetCollection;
    }

    protected void setError(Exception exception) {
        exception.printStackTrace();
        this.atomSetCollection.errorMessage = this.line == null ? "Unexpected end of file after line " + --this.ptLine + ":\n" + this.prevline : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + exception.getMessage();
    }

    void initialize(Hashtable hashtable) {
        Object object;
        int n;
        this.initializeSymmetry();
        this.htParams = hashtable;
        this.getHeader = hashtable.containsKey("getHeader");
        this.readerName = (String)hashtable.get("readerName");
        if (hashtable.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)hashtable.get("modelNumber");
        }
        this.applySymmetryToBonds = hashtable.containsKey("applySymmetryToBonds");
        this.filter = (String)hashtable.get("filter");
        this.haveAtomFilter = this.filter != null && (this.filter.indexOf(".") >= 0 || this.filter.indexOf("[") >= 0 || this.filter.indexOf(":") >= 0 || this.filter.toUpperCase().indexOf("BIOMOLECULE") >= 0);
        this.havePartialChargeFilter = this.filter != null && this.filter.toLowerCase().indexOf("charge=") >= 0;
        this.bsFilter = (BitSet)hashtable.get("bsFilter");
        if (this.bsFilter == null && this.filter != null) {
            this.bsFilter = new BitSet();
            hashtable.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            Logger.info("filtering with " + this.filter);
        }
        int n2 = n = hashtable.containsKey("ptFile") ? (Integer)hashtable.get("ptFile") : -1;
        if (n > 0 && hashtable.containsKey("firstLastSteps")) {
            object = ((Vector)hashtable.get("firstLastSteps")).elementAt(n - 1);
            if (object instanceof BitSet) {
                this.bsModels = (BitSet)object;
            } else {
                this.firstLastStep = (int[])object;
            }
            this.templateAtomCount = (Integer)hashtable.get("templateAtomCount");
        } else if (hashtable.containsKey("firstLastStep")) {
            this.isTrajectory = hashtable.containsKey("isTrajectory");
            this.firstLastStep = (int[])hashtable.get("firstLastStep");
        } else if (hashtable.containsKey("bsModels")) {
            this.isTrajectory = hashtable.containsKey("isTrajectory");
            this.bsModels = (BitSet)hashtable.get("bsModels");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = new BitSet();
            this.bsModels.set(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = BitSetUtil.length(this.bsModels);
        }
        this.symmetryRange = hashtable.containsKey("symmetryRange") ? ((Float)hashtable.get("symmetryRange")).floatValue() : 0.0f;
        this.latticeCells = new int[3];
        if (hashtable.containsKey("lattice")) {
            object = (Point3f)hashtable.get("lattice");
            this.latticeCells[0] = (int)((Tuple3f)object).x;
            this.latticeCells[1] = (int)((Tuple3f)object).y;
            this.latticeCells[2] = (int)((Tuple3f)object).z;
            this.doPackUnitCell = hashtable.containsKey("packed") || this.latticeCells[2] < 0;
        }
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (hashtable.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)hashtable.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.spaceGroup = (String)hashtable.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl2 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (hashtable.containsKey("unitcell")) {
            object = (float[])hashtable.get("unitcell");
            this.setUnitCell((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
    }

    protected boolean doGetModel(int n) {
        boolean bl = this.bsModels == null ? this.desiredModelNumber == Integer.MIN_VALUE || n == this.desiredModelNumber : (n > this.lastModelNumber ? false : n > 0 && this.bsModels.get(n - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (n - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0));
        this.haveModel |= bl;
        return bl;
    }

    protected boolean isLastModel(int n) {
        return this.desiredModelNumber != Integer.MIN_VALUE || n >= this.lastModelNumber;
    }

    private void initializeSymmetry() {
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int n = 22;
            while (--n >= 0) {
                this.notionalUnitCell[n] = Float.NaN;
            }
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified *";
        }
        this.needToApplySymmetry = false;
    }

    protected void newAtomSet(String string) {
        if (this.atomSetCollection.currentAtomSetIndex >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.currentAtomSetIndex + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(string);
        }
        Logger.debug(string);
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = string.trim();
    }

    public void setSymmetryOperator(String string) {
        if (this.ignoreFileSymmetryOperators) {
            return;
        }
        this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
        if (!this.atomSetCollection.addSpaceGroupOperation(string)) {
            Logger.warn("Skipping symmetry operation " + string);
        }
        this.iHaveSymmetryOperators = true;
    }

    private void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.notionalUnitCell[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.notionalUnitCell[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearLatticeParameters() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < this.notionalUnitCell.length; ++i) {
            this.notionalUnitCell[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (!Float.isNaN(f) && n >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[n] = f;
        if (Logger.debugging) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6 || Float.isNaN(f)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    protected void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.notionalUnitCell[0] = f;
        this.notionalUnitCell[1] = f2;
        this.notionalUnitCell[2] = f3;
        if (f4 != 0.0f) {
            this.notionalUnitCell[3] = f4;
        }
        if (f5 != 0.0f) {
            this.notionalUnitCell[4] = f5;
        }
        if (f6 != 0.0f) {
            this.notionalUnitCell[5] = f6;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int n, float[] fArray) {
        n = 6 + n * 3;
        this.notionalUnitCell[n++] = fArray[0];
        this.notionalUnitCell[n++] = fArray[1];
        this.notionalUnitCell[n++] = fArray[2];
        this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.newSymmetry().setUnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    private SymmetryInterface newSymmetry() {
        this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
    }

    protected boolean filterAtom(Atom atom) {
        return !this.haveAtomFilter || this.filterAtom(atom, this.atomSetCollection.atomCount);
    }

    protected boolean filterAtom(Atom atom, int n) {
        boolean bl;
        block5: {
            block6: {
                String string;
                block4: {
                    bl = false;
                    if (atom.group3 == null) break block4;
                    string = "[" + atom.group3.toUpperCase() + "]";
                    if (this.filter.indexOf("![") < 0 ? this.filter.indexOf("[") >= 0 && this.filter.toUpperCase().indexOf(string) < 0 : this.filter.toUpperCase().indexOf(string) >= 0) break block5;
                }
                if (atom.atomName == null) break block6;
                string = "." + atom.atomName.toUpperCase() + ";";
                if (this.filter.indexOf("!.") < 0 ? this.filter.indexOf("*.") >= 0 && this.filter.toUpperCase().indexOf(string) < 0 : this.filter.toUpperCase().indexOf(string) >= 0) break block5;
            }
            if (!(this.filter.indexOf("!:") >= 0 ? this.filter.indexOf(":" + atom.chainID) >= 0 : this.filter.indexOf(":") >= 0 && this.filter.indexOf(":" + atom.chainID) < 0)) {
                bl = true;
            }
        }
        this.bsFilter.set(n, bl);
        return bl;
    }

    public void setAtomCoord(Atom atom, float f, float f2, float f3) {
        atom.set(f, f2, f3);
        this.setAtomCoord(atom);
    }

    public void setAtomCoord(Atom atom) {
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.symmetry != null) {
            this.symmetry.toFractional(atom);
            this.iHaveFractionalCoordinates = true;
        }
        this.needToApplySymmetry = true;
    }

    protected void addSites(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbSites", hashtable);
        Enumeration enumeration = hashtable.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            int n = string2.length();
            while (--n >= 0) {
                char c = string2.charAt(n);
                if (Character.isLetterOrDigit(c) || c == '\'') continue;
                string2 = string2.substring(0, n) + "_" + string2.substring(n + 1);
            }
            String string3 = (String)hashtable2.get("seqNum");
            String string4 = (String)hashtable2.get("groups");
            if (string4.length() == 0) continue;
            this.addJmolScript("@site_" + string2 + " " + string4);
            this.addJmolScript("@" + string3 + " " + string4);
            this.addJmolScript("site_" + string2 + " = \"" + string4 + "\".split(\",\")");
            string = string + (string == "" ? "" : ",") + "site_" + string2;
        }
        this.addJmolScript("site_list = \"" + string + "\".split(\",\")");
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        if (!this.needToApplySymmetry || !this.iHaveUnitCell) {
            this.initializeSymmetry();
            return;
        }
        this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
        this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell);
        this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
        this.atomSetCollection.setSymmetryRange(this.symmetryRange);
        if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
            this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
            if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                SymmetryInterface symmetryInterface = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                if (symmetryInterface.createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("*") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell, this.atomSetCollection.doNormalize)) {
                    this.atomSetCollection.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
                    this.atomSetCollection.applySymmetry(symmetryInterface);
                }
            } else {
                this.atomSetCollection.applySymmetry();
            }
        }
        this.initializeSymmetry();
    }

    public void setMOData(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", hashtable);
        Vector vector = (Vector)hashtable.get("mos");
        if (vector != null) {
            Logger.info(vector.size() + " molecular orbitals read in model " + this.modelNumber);
        }
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.matrixRotate != null) {
            return;
        }
        this.matrixRotate = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        vector3f.set(f, f2, f3);
        vector3f.normalize();
        this.matrixRotate.setColumn(0, vector3f);
        vector3f.set(f4, f5, f6);
        vector3f.normalize();
        this.matrixRotate.setColumn(1, vector3f);
        vector3f.set(f7, f8, f9);
        vector3f.normalize();
        this.matrixRotate.setColumn(2, vector3f);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationMatrix", new Matrix3f(this.matrixRotate));
        Quaternion quaternion = new Quaternion(this.matrixRotate);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationQuaternion", quaternion);
        Logger.info("defaultOrientationMatrix = " + this.matrixRotate);
    }

    public static String getElementSymbol(int n) {
        return JmolAdapter.getElementSymbol(n);
    }

    protected static String deducePdbElementSymbol(boolean bl, String string, String string2) {
        int n = string.indexOf(0);
        String string3 = null;
        if (n >= 0) {
            string3 = string.substring(n + 1);
            string = string.substring(0, n);
            if (string3 != null && string3.length() == 1) {
                return string3;
            }
        }
        if (string.equalsIgnoreCase(string2)) {
            return string;
        }
        int n2 = string.length();
        char c = ' ';
        n = 0;
        while (n < n2) {
            char c2 = string.charAt(n++);
            c = c2;
            if (c2 <= '9') continue;
        }
        char c3 = n < n2 ? (char)string.charAt(n) : (char)' ';
        String string4 = string2 + "." + c + c3;
        if ("OEC.CA ICA.CA OC1.CA OC2.CA OC4.CA".indexOf(string4) >= 0) {
            return "Ca";
        }
        if (string.indexOf("'") > 0 || string.indexOf("*") >= 0 || "HCNO".indexOf(c) >= 0 && c3 <= 'H' || string.startsWith("CM")) {
            return "" + c;
        }
        if (bl && Atom.isValidElementSymbolNoCaseSecondChar(c, c3)) {
            return ("" + c + c3).trim();
        }
        if (Atom.isValidElementSymbol(c)) {
            return "" + c;
        }
        if (Atom.isValidElementSymbol(c3)) {
            return "" + c3;
        }
        return "Xx";
    }

    protected void fillDataBlock(String[][] stringArray) throws Exception {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = AtomSetCollectionReader.getTokens(this.discardLinesUntilNonBlank());
        }
    }

    protected void discardLines(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    protected String discardLinesUntilStartsWith(String string) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(string)) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains(String string) throws Exception {
        while (this.readLine() != null && this.line.indexOf(string) < 0) {
        }
        return this.line;
    }

    protected void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    protected String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String string) {
        this.line = string;
        this.checkLineForScript();
    }

    public void checkLineForScript() {
        int n;
        if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", "" + this.line);
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setNoAutoBond();
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            String string = this.line.substring(n + 11, this.line.length());
            if (string.indexOf("#") >= 0) {
                string = string.substring(0, string.indexOf("#"));
            }
            this.addJmolScript(string);
            this.line = this.line.substring(0, n).trim();
        }
    }

    protected void addJmolScript(String string) {
        Logger.info("#jmolScript: " + string);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolscript", this.previousScript);
    }

    public String readLine() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        ++this.ptLine;
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected String readLineTrimmed() throws Exception {
        this.readLine();
        if (this.line == null) {
            this.line = "";
        }
        this.line = this.line.trim();
        return this.line;
    }

    protected static final String[] getStrings(String string, int n, int n2) {
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            stringArray[n3] = string.substring(n4, n4 + n2);
            ++n3;
            n4 += n2;
        }
        return stringArray;
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected static void getTokensFloat(String string, float[] fArray, int n) {
        Parser.parseFloatArray(AtomSetCollectionReader.getTokens(string), fArray, n);
    }

    public static String[] getTokens(String string) {
        return Parser.getTokens(string);
    }

    protected static String[] getTokens(String string, int n) {
        return Parser.getTokens(string, n);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    public float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected float parseFloat(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseFloat(string, n2, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    public int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n) {
        this.next[0] = n;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseInt(string, n2, this.next);
    }

    protected String parseToken() {
        return Parser.parseToken(this.line, this.next);
    }

    protected String parseToken(String string) {
        this.next[0] = 0;
        return Parser.parseToken(string, this.next);
    }

    protected String parseTokenNext(String string) {
        return Parser.parseToken(string, this.next);
    }

    protected String parseToken(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseToken(string, n2, this.next);
    }

    protected static String parseTrimmed(String string, int n) {
        return Parser.parseTrimmed(string, n);
    }

    protected static String parseTrimmed(String string, int n, int n2) {
        return Parser.parseTrimmed(string, n, n2);
    }
}

