/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;

public final class BitSetUtil {
    private static final BitSet bsNull = new BitSet();

    public static int length(BitSet bitSet) {
        int n = bitSet.size();
        while (--n >= 0 && !bitSet.get(n)) {
        }
        return n + 1;
    }

    public static int firstSetBit(BitSet bitSet) {
        int n;
        if (bitSet == null || (n = bitSet.size()) == 0) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static int cardinalityOf(BitSet bitSet) {
        int n = 0;
        if (bitSet != null) {
            int n2 = bitSet.size();
            while (--n2 >= 0) {
                if (!bitSet.get(n2)) continue;
                ++n;
            }
        }
        return n;
    }

    public static BitSet setAll(int n) {
        BitSet bitSet = new BitSet(n);
        int n2 = n;
        while (--n2 >= 0) {
            bitSet.set(n2);
        }
        return bitSet;
    }

    public static void andNot(BitSet bitSet, BitSet bitSet2) {
        if (bitSet2 == null) {
            return;
        }
        int n = bitSet2.size();
        while (--n >= 0) {
            if (!bitSet2.get(n)) continue;
            bitSet.clear(n);
        }
    }

    public static BitSet copy(BitSet bitSet) {
        return bitSet == null ? null : (BitSet)bitSet.clone();
    }

    public static void copy(BitSet bitSet, BitSet bitSet2) {
        bitSet2.clear();
        bitSet2.or(bitSet);
    }

    public static void clear(BitSet bitSet) {
        bitSet.and(bsNull);
    }

    public static BitSet copyInvert(BitSet bitSet, int n) {
        if (bitSet == null) {
            return null;
        }
        BitSet bitSet2 = BitSetUtil.setAll(n);
        BitSetUtil.andNot(bitSet2, bitSet);
        return bitSet2;
    }

    public static BitSet invertInPlace(BitSet bitSet, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (bitSet.get(n2)) {
                bitSet.clear(n2);
                continue;
            }
            bitSet.set(n2);
        }
        return bitSet;
    }

    public static BitSet toggleInPlace(BitSet bitSet, BitSet bitSet2, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (!bitSet2.get(n2)) continue;
            if (bitSet.get(n2)) {
                bitSet.clear(n2);
                continue;
            }
            bitSet.or(bitSet2);
            break;
        }
        return bitSet;
    }

    public static void deleteBits(BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null || bitSet2 == null) {
            return;
        }
        int n = BitSetUtil.firstSetBit(bitSet2);
        if (n < 0) {
            return;
        }
        int n2 = bitSet.size();
        int n3 = Math.min(n2, bitSet2.size());
        for (int i = n; i < n3; ++i) {
            if (bitSet2.get(i)) continue;
            bitSet.set(n++, bitSet.get(i));
        }
        while (n < n2) {
            bitSet.clear(n);
            ++n;
        }
    }

    public static boolean compareBits(BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null || bitSet2 == null) {
            return bitSet == null && bitSet2 == null;
        }
        int n = Math.max(bitSet.size(), bitSet2.size());
        while (--n >= 0) {
            if (bitSet.get(n) == bitSet2.get(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommon(BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null || bitSet2 == null) {
            return false;
        }
        int n = Math.min(bitSet.size(), bitSet2.size());
        while (--n >= 0) {
            if (!bitSet.get(n) || !bitSet2.get(n)) continue;
            return true;
        }
        return false;
    }
}

