/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class MonitorInputStream
extends FilterInputStream {
    int length;
    int position;
    int markPosition;
    int readEventCount;

    MonitorInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.length = n;
        this.position = 0;
    }

    public int read() throws IOException {
        ++this.readEventCount;
        int n = super.read();
        if (n >= 0) {
            ++this.position;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        ++this.readEventCount;
        int n = super.read(byArray);
        if (n > 0) {
            this.position += n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        ++this.readEventCount;
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.position += n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.position = (int)((long)this.position + l2);
        return l2;
    }

    public void mark(int n) {
        super.mark(n);
        this.markPosition = this.position;
    }

    public void reset() throws IOException {
        this.position = this.markPosition;
        super.reset();
    }

    int getPosition() {
        return this.position;
    }

    int getLength() {
        return this.length;
    }

    int getPercentageRead() {
        return this.position * 100 / this.length;
    }
}

