/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClockTime
implements Comparable<ClockTime> {
    public static final ClockTime NONE = new ClockTime(-1L, TimeUnit.NANOSECONDS);
    public static final ClockTime ZERO = new ClockTime(0L, TimeUnit.NANOSECONDS);
    private final long value;

    private ClockTime(long time, TimeUnit units) {
        this.value = units.toNanos(time);
    }

    public static ClockTime fromMicros(long microseconds) {
        return ClockTime.valueOf(microseconds, TimeUnit.MICROSECONDS);
    }

    public static ClockTime fromMillis(long milliseconds) {
        return ClockTime.valueOf(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static ClockTime fromNanos(long nanoseconds) {
        return ClockTime.valueOf(nanoseconds, TimeUnit.NANOSECONDS);
    }

    public static ClockTime fromSeconds(long seconds) {
        return ClockTime.valueOf(seconds, TimeUnit.SECONDS);
    }

    public static ClockTime valueOf(long time, TimeUnit units) {
        long nanoseconds = units.toNanos(time);
        if (nanoseconds == -1L) {
            return NONE;
        }
        if (nanoseconds == 0L) {
            return ZERO;
        }
        return new ClockTime(time, units);
    }

    public long getHours() {
        return this.toSeconds() / 3600L % 24L;
    }

    public long getMinutes() {
        return this.toSeconds() / 60L % 60L;
    }

    public long getSeconds() {
        return this.toSeconds() % 60L;
    }

    public long getNanoSeconds() {
        return this.value % TimeUnit.SECONDS.toNanos(1L);
    }

    public long convertTo(TimeUnit unit) {
        return unit.convert(this.value, TimeUnit.NANOSECONDS);
    }

    public long toMicros() {
        return this.convertTo(TimeUnit.MICROSECONDS);
    }

    public long toMillis() {
        return this.convertTo(TimeUnit.MILLISECONDS);
    }

    public long toNanos() {
        return this.convertTo(TimeUnit.NANOSECONDS);
    }

    public long toSeconds() {
        return this.convertTo(TimeUnit.SECONDS);
    }

    public boolean isValid() {
        return this.value != ClockTime.NONE.value;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d", this.getHours(), this.getMinutes(), this.getSeconds());
    }

    public boolean equals(Object obj) {
        return obj instanceof ClockTime && ((ClockTime)obj).value == this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int compareTo(ClockTime time) {
        if (this.value < time.value) {
            return -1;
        }
        if (this.value > time.value) {
            return 1;
        }
        return 0;
    }
}

