/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Message;
import org.gstreamer.Pad;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.TestPipe;
import org.gstreamer.message.TagMessage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElementTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("ElementTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void getPads() {
        Element element = ElementFactory.make("fakesink", "fs");
        List<Pad> pads = element.getPads();
        Assert.assertTrue((String)"no pads found", (!pads.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void getSinkPads() {
        Element element = ElementFactory.make("fakesink", "fs");
        List<Pad> pads = element.getSinkPads();
        Assert.assertTrue((String)"no pads found", (!pads.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void getSrcPads() {
        Element element = ElementFactory.make("fakesrc", "fs");
        List<Pad> pads = element.getSrcPads();
        Assert.assertTrue((String)"no pads found", (!pads.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void setState() {
        Element element = ElementFactory.make("fakesrc", "fs");
        element.setState(State.PLAYING);
        element.setState(State.NULL);
    }

    @Test
    public void getState() {
        Element element = ElementFactory.make("fakesrc", "fs");
        element.setState(State.PLAYING);
        State state = element.getState(-1L);
        Assert.assertEquals((String)"Element state not set correctly", (Object)State.PLAYING, (Object)state);
        element.setState(State.NULL);
    }

    @Test
    public void postMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final TagMessage message = new TagMessage(pipe.src, new TagList());
        pipe.getBus().connect(new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                if (msg.equals(message)) {
                    signalFired.set(true);
                    pipe.quit();
                }
            }
        });
        pipe.sink.postMessage(message);
        pipe.run();
        Assert.assertTrue((String)"Message not posted", (boolean)signalFired.get());
    }
}

