/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Callback;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.ClockTime;
import org.gstreamer.Closure;
import org.gstreamer.glib.GQuark;
import org.gstreamer.lowlevel.EnumMapper;
import org.gstreamer.lowlevel.GObjectAPI;
import org.gstreamer.lowlevel.GSignalAPI;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GstTypes;
import org.gstreamer.lowlevel.IntPtr;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.RefCountedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GObject
extends RefCountedObject {
    private static final Logger logger = Logger.getLogger(GObject.class.getName());
    private static final Level LIFECYCLE = Level.FINE;
    private static final Map<GObject, Boolean> strongReferences = new ConcurrentHashMap<GObject, Boolean>();
    private Map<Class<?>, Map<Object, GCallback>> callbackListeners;
    private Map<String, Map<Closure, ClosureProxy>> signalClosures;
    private final IntPtr objectID = new IntPtr(System.identityHashCode(this));
    private static final GObjectAPI.GToggleNotify toggle = new GObjectAPI.GToggleNotify(){

        public void callback(Pointer data, Pointer ptr, boolean is_last_ref) {
            GObject o = (GObject)GObject.instanceFor(ptr);
            if (o == null) {
                return;
            }
            logger.log(LIFECYCLE, "toggle_ref " + o.getClass().getSimpleName() + " (" + ptr + ")" + " last_ref=" + is_last_ref);
            if (is_last_ref) {
                strongReferences.remove(o);
            } else {
                strongReferences.put(o, Boolean.TRUE);
            }
        }
    };

    public GObject(NativeObject.Initializer init) {
        super(init.needRef ? GObject.initializer(init.ptr, false, init.ownsHandle) : init);
        logger.entering("GObject", "<init>", new Object[]{init});
        if (init.ownsHandle) {
            strongReferences.put(this, Boolean.TRUE);
            GObjectAPI.GOBJECT_API.g_object_add_toggle_ref(init.ptr, toggle, this.objectID);
            if (!init.needRef) {
                this.unref();
            }
        }
    }

    public void set(String property, Object data) {
        logger.entering("GObject", "set", new Object[]{property, data});
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        GValueAPI.GValue propValue = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(propValue, propType);
        if (propType.equals((Object)GType.INT)) {
            GValueAPI.GVALUE_API.g_value_set_int(propValue, GObject.intValue(data));
        } else if (propType.equals((Object)GType.UINT)) {
            GValueAPI.GVALUE_API.g_value_set_uint(propValue, GObject.intValue(data));
        } else if (propType.equals((Object)GType.CHAR)) {
            GValueAPI.GVALUE_API.g_value_set_char(propValue, (byte)GObject.intValue(data));
        } else if (propType.equals((Object)GType.UCHAR)) {
            GValueAPI.GVALUE_API.g_value_set_uchar(propValue, (byte)GObject.intValue(data));
        } else if (propType.equals((Object)GType.LONG)) {
            GValueAPI.GVALUE_API.g_value_set_long(propValue, new NativeLong(GObject.longValue(data)));
        } else if (propType.equals((Object)GType.ULONG)) {
            GValueAPI.GVALUE_API.g_value_set_ulong(propValue, new NativeLong(GObject.longValue(data)));
        } else if (propType.equals((Object)GType.INT64)) {
            GValueAPI.GVALUE_API.g_value_set_int64(propValue, GObject.longValue(data));
        } else if (propType.equals((Object)GType.UINT64)) {
            GValueAPI.GVALUE_API.g_value_set_uint64(propValue, GObject.longValue(data));
        } else if (propType.equals((Object)GType.BOOLEAN)) {
            GValueAPI.GVALUE_API.g_value_set_boolean(propValue, GObject.booleanValue(data));
        } else if (propType.equals((Object)GType.FLOAT)) {
            GValueAPI.GVALUE_API.g_value_set_float(propValue, GObject.floatValue(data));
        } else if (propType.equals((Object)GType.DOUBLE)) {
            GValueAPI.GVALUE_API.g_value_set_double(propValue, GObject.doubleValue(data));
        } else if (propType.equals((Object)GType.STRING)) {
            if (data instanceof URI) {
                URI uri = (URI)data;
                String uriString = uri.toString();
                if ("file".equals(uri.getScheme()) && uri.getHost() == null) {
                    String path = uri.getRawPath();
                    uriString = "file://" + path;
                }
                GValueAPI.GVALUE_API.g_value_set_string(propValue, uriString);
            } else {
                GValueAPI.GVALUE_API.g_value_set_string(propValue, data.toString());
            }
        } else if (propType.equals((Object)GType.OBJECT)) {
            GValueAPI.GVALUE_API.g_value_set_object(propValue, (GObject)data);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.INT64, propType)) {
            GObject.transform(data, GType.INT64, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.LONG, propType)) {
            GObject.transform(data, GType.LONG, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.INT, propType)) {
            GObject.transform(data, GType.INT, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.DOUBLE, propType)) {
            GObject.transform(data, GType.DOUBLE, propValue);
        } else if (GValueAPI.GVALUE_API.g_value_type_transformable(GType.FLOAT, propType)) {
            GObject.transform(data, GType.FLOAT, propValue);
        } else {
            GObjectAPI.GOBJECT_API.g_object_set(this, property, data);
            return;
        }
        GObjectAPI.GOBJECT_API.g_object_set_property(this, property, propValue);
        GValueAPI.GVALUE_API.g_value_unset(propValue);
    }

    public Object getPropertyDefaultValue(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return this.findProperty(property, propType).getDefault();
    }

    public Object getPropertyMinimumValue(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return this.findProperty(property, propType).getMinimum();
    }

    public Object getPropertyMaximumValue(String property) {
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return this.findProperty(property, propType).getMaximum();
    }

    public Object get(String property) {
        Class<? extends NativeObject> cls;
        logger.entering("GObject", "get", new Object[]{property});
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        GValueAPI.GValue propValue = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(propValue, propType);
        GObjectAPI.GOBJECT_API.g_object_get_property(this, property, propValue);
        if (propType.equals((Object)GType.INT)) {
            return GValueAPI.GVALUE_API.g_value_get_int(propValue);
        }
        if (propType.equals((Object)GType.UINT)) {
            return GValueAPI.GVALUE_API.g_value_get_uint(propValue);
        }
        if (propType.equals((Object)GType.CHAR)) {
            return (int)GValueAPI.GVALUE_API.g_value_get_char(propValue);
        }
        if (propType.equals((Object)GType.UCHAR)) {
            return (int)GValueAPI.GVALUE_API.g_value_get_uchar(propValue);
        }
        if (propType.equals((Object)GType.LONG)) {
            return GValueAPI.GVALUE_API.g_value_get_long(propValue).longValue();
        }
        if (propType.equals((Object)GType.ULONG)) {
            return GValueAPI.GVALUE_API.g_value_get_ulong(propValue).longValue();
        }
        if (propType.equals((Object)GType.INT64)) {
            return GValueAPI.GVALUE_API.g_value_get_int64(propValue);
        }
        if (propType.equals((Object)GType.UINT64)) {
            return GValueAPI.GVALUE_API.g_value_get_uint64(propValue);
        }
        if (propType.equals((Object)GType.BOOLEAN)) {
            return GValueAPI.GVALUE_API.g_value_get_boolean(propValue);
        }
        if (propType.equals((Object)GType.FLOAT)) {
            return Float.valueOf(GValueAPI.GVALUE_API.g_value_get_float(propValue));
        }
        if (propType.equals((Object)GType.DOUBLE)) {
            return GValueAPI.GVALUE_API.g_value_get_double(propValue);
        }
        if (propType.equals((Object)GType.STRING)) {
            return GValueAPI.GVALUE_API.g_value_get_string(propValue);
        }
        if (propType.equals((Object)GType.OBJECT)) {
            return GValueAPI.GVALUE_API.g_value_dup_object(propValue);
        }
        if (GValueAPI.GVALUE_API.g_value_type_transformable(propType, GType.OBJECT)) {
            return GValueAPI.GVALUE_API.g_value_dup_object(GObject.transform(propValue, GType.OBJECT));
        }
        if (GValueAPI.GVALUE_API.g_value_type_transformable(propType, GType.INT)) {
            return GValueAPI.GVALUE_API.g_value_get_int(GObject.transform(propValue, GType.INT));
        }
        if (GValueAPI.GVALUE_API.g_value_type_transformable(propType, GType.INT64)) {
            return GValueAPI.GVALUE_API.g_value_get_int64(GObject.transform(propValue, GType.INT64));
        }
        if (propValue.checkHolds(GType.BOXED) && (cls = GstTypes.classFor(propType)) != null) {
            Pointer ptr = GValueAPI.GVALUE_API.g_value_get_boxed(propValue);
            return NativeObject.objectFor(ptr, cls, -1, true);
        }
        throw new IllegalArgumentException("Unknown conversion from GType=" + (Object)((Object)propType));
    }

    public GType getType(String property) {
        logger.entering("GObject", "getType", new Object[]{property});
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        GType propType = propertySpec.value_type;
        return propType;
    }

    public Pointer getPointer(String property) {
        logger.entering("GObject", "getPointer", new Object[]{property});
        GObjectAPI.GParamSpec propertySpec = this.findProperty(property);
        if (propertySpec == null) {
            throw new IllegalArgumentException("Unknown property: " + property);
        }
        PointerByReference refPtr = new PointerByReference();
        GObjectAPI.GOBJECT_API.g_object_get(this, property, refPtr, null);
        if (refPtr != null) {
            Pointer ptr = refPtr.getValue();
            return ptr;
        }
        throw new IllegalArgumentException("Got NULL pointer for property=" + property);
    }

    private static GValueAPI.GValue transform(GValueAPI.GValue src, GType dstType) {
        GValueAPI.GValue dst = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(dst, dstType);
        GValueAPI.GVALUE_API.g_value_transform(src, dst);
        return dst;
    }

    private static void transform(Object data, GType type, GValueAPI.GValue dst) {
        GValueAPI.GValue src = new GValueAPI.GValue();
        GValueAPI.GVALUE_API.g_value_init(src, type);
        GObject.setGValue(src, type, data);
        GValueAPI.GVALUE_API.g_value_transform(src, dst);
    }

    private static boolean setGValue(GValueAPI.GValue value, GType type, Object data) {
        if (type.equals((Object)GType.INT)) {
            GValueAPI.GVALUE_API.g_value_set_int(value, GObject.intValue(data));
        } else if (type.equals((Object)GType.UINT)) {
            GValueAPI.GVALUE_API.g_value_set_uint(value, GObject.intValue(data));
        } else if (type.equals((Object)GType.CHAR)) {
            GValueAPI.GVALUE_API.g_value_set_char(value, (byte)GObject.intValue(data));
        } else if (type.equals((Object)GType.UCHAR)) {
            GValueAPI.GVALUE_API.g_value_set_uchar(value, (byte)GObject.intValue(data));
        } else if (type.equals((Object)GType.LONG)) {
            GValueAPI.GVALUE_API.g_value_set_long(value, new NativeLong(GObject.longValue(data)));
        } else if (type.equals((Object)GType.ULONG)) {
            GValueAPI.GVALUE_API.g_value_set_ulong(value, new NativeLong(GObject.longValue(data)));
        } else if (type.equals((Object)GType.INT64)) {
            GValueAPI.GVALUE_API.g_value_set_int64(value, GObject.longValue(data));
        } else if (type.equals((Object)GType.UINT64)) {
            GValueAPI.GVALUE_API.g_value_set_uint64(value, GObject.longValue(data));
        } else if (type.equals((Object)GType.BOOLEAN)) {
            GValueAPI.GVALUE_API.g_value_set_boolean(value, GObject.booleanValue(data));
        } else if (type.equals((Object)GType.FLOAT)) {
            GValueAPI.GVALUE_API.g_value_set_float(value, GObject.floatValue(data));
        } else if (type.equals((Object)GType.DOUBLE)) {
            GValueAPI.GVALUE_API.g_value_set_double(value, GObject.doubleValue(data));
        } else {
            return false;
        }
        return true;
    }

    private static boolean booleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Expected boolean value, not " + value.getClass());
    }

    private static int intValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalArgumentException("Expected integer value, not " + value.getClass());
    }

    private static long longValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new IllegalArgumentException("Expected long value, not " + value.getClass());
    }

    private static float floatValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new IllegalArgumentException("Expected float value, not " + value.getClass());
    }

    private static double doubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new IllegalArgumentException("Expected double value, not " + value.getClass());
    }

    @Override
    protected void disposeNativeHandle(Pointer ptr) {
        logger.log(LIFECYCLE, "Removing toggle ref " + this.getClass().getSimpleName() + " (" + ptr + ")");
        GObjectAPI.GOBJECT_API.g_object_remove_toggle_ref(ptr, toggle, this.objectID);
    }

    @Override
    protected void ref() {
        GObjectAPI.GOBJECT_API.g_object_ref(this);
    }

    @Override
    protected void unref() {
        GObjectAPI.GOBJECT_API.g_object_unref(this);
    }

    @Override
    protected void invalidate() {
        try {
            if (this.ownsHandle.get()) {
                this.ref();
                GObjectAPI.GOBJECT_API.g_object_remove_toggle_ref(this.handle(), toggle, this.objectID);
            }
            strongReferences.remove(this);
        }
        finally {
            super.invalidate();
        }
    }

    protected NativeLong g_signal_connect(String signal, Callback callback) {
        logger.entering("GObject", "g_signal_connect", new Object[]{signal, callback});
        return GObjectAPI.GOBJECT_API.g_signal_connect_data(this, signal, callback, null, null, 0);
    }

    private final synchronized Map<Class<?>, Map<Object, GCallback>> getCallbackMap() {
        if (this.callbackListeners == null) {
            this.callbackListeners = new ConcurrentHashMap();
        }
        return this.callbackListeners;
    }

    private final synchronized Map<String, Map<Closure, ClosureProxy>> getClosureMap() {
        if (this.signalClosures == null) {
            this.signalClosures = new ConcurrentHashMap<String, Map<Closure, ClosureProxy>>();
        }
        return this.signalClosures;
    }

    protected synchronized <T> void addCallback(Class<T> listenerClass, T listener, GCallback cb) {
        Map<Class<?>, Map<Object, GCallback>> signals = this.getCallbackMap();
        Map<Object, GCallback> m = signals.get(listenerClass);
        if (m == null) {
            m = new HashMap<Object, GCallback>();
            signals.put(listenerClass, m);
        }
        m.put(listener, cb);
    }

    public synchronized <T> void removeCallback(Class<T> listenerClass, T listener) {
        Map<Class<?>, Map<Object, GCallback>> signals = this.getCallbackMap();
        Map<Object, GCallback> map = signals.get(listenerClass);
        if (map != null) {
            GCallback cb = map.remove(listener);
            if (cb != null) {
                cb.remove();
            }
            if (map.isEmpty()) {
                signals.remove(listenerClass);
                if (this.callbackListeners.isEmpty()) {
                    this.callbackListeners = null;
                }
            }
        }
    }

    public <T> void connect(Class<T> listenerClass, T listener, Callback cb) {
        String signal = listenerClass.getSimpleName().toLowerCase().replaceAll("_", "-");
        this.connect(signal, listenerClass, listener, cb);
    }

    public synchronized <T> void connect(String signal, Class<T> listenerClass, T listener, Callback cb) {
        this.addCallback(listenerClass, listener, new SignalCallback(signal, cb));
    }

    public synchronized <T> void disconnect(Class<T> listenerClass, T listener) {
        this.removeCallback(listenerClass, listener);
    }

    public synchronized void connect(String signal, Closure closure) {
        Map<String, Map<Closure, ClosureProxy>> signals = this.getClosureMap();
        Map<Closure, ClosureProxy> m = signals.get(signal);
        if (m == null) {
            m = new HashMap<Closure, ClosureProxy>();
            signals.put(signal, m);
        }
        m.put(closure, new ClosureProxy(signal, closure));
    }

    public synchronized void disconnect(String signal, Closure closure) {
        Map<String, Map<Closure, ClosureProxy>> signals = this.signalClosures;
        if (signals == null) {
            return;
        }
        Map<Closure, ClosureProxy> map = signals.get(signal);
        if (map != null) {
            ClosureProxy cb = map.remove(signal);
            if (cb != null) {
                cb.disconnect();
            }
            if (map.isEmpty()) {
                signals.remove(signal);
                if (this.signalClosures.isEmpty()) {
                    this.signalClosures = null;
                }
            }
        }
    }

    public synchronized void emit(int signal_id, GQuark detail, Object ... arguments) {
        GSignalAPI.GSIGNAL_API.g_signal_emit(this, signal_id, detail, arguments);
    }

    public synchronized void emit(String signal, Object ... arguments) {
        GSignalAPI.GSIGNAL_API.g_signal_emit_by_name(this, signal, arguments);
    }

    public static <T extends GObject> T objectFor(Pointer ptr, Class<T> defaultClass) {
        return (T)((GObject)GObject.objectFor(ptr, defaultClass, true));
    }

    private GObjectAPI.GParamSpec findProperty(String propertyName) {
        Pointer ptr = GObjectAPI.GOBJECT_API.g_object_class_find_property(this.handle().getPointer(0L), propertyName);
        if (ptr == null) {
            return null;
        }
        return new GObjectAPI.GParamSpec(ptr);
    }

    private GObjectAPI.GParamSpecTypeSpecific findProperty(String propertyName, GType type) {
        Pointer ptr = GObjectAPI.GOBJECT_API.g_object_class_find_property(this.handle().getPointer(0L), propertyName);
        if (type.equals((Object)GType.INT)) {
            return new GObjectAPI.GParamSpecInt(ptr);
        }
        if (type.equals((Object)GType.UINT)) {
            return new GObjectAPI.GParamSpecUInt(ptr);
        }
        if (type.equals((Object)GType.CHAR)) {
            return new GObjectAPI.GParamSpecChar(ptr);
        }
        if (type.equals((Object)GType.UCHAR)) {
            return new GObjectAPI.GParamSpecUChar(ptr);
        }
        if (type.equals((Object)GType.BOOLEAN)) {
            return new GObjectAPI.GParamSpecBoolean(ptr);
        }
        if (type.equals((Object)GType.LONG)) {
            return new GObjectAPI.GParamSpecLong(ptr);
        }
        if (type.equals((Object)GType.ULONG)) {
            return new GObjectAPI.GParamSpecLong(ptr);
        }
        if (type.equals((Object)GType.INT64)) {
            return new GObjectAPI.GParamSpecInt64(ptr);
        }
        if (type.equals((Object)GType.UINT64)) {
            return new GObjectAPI.GParamSpecInt64(ptr);
        }
        if (type.equals((Object)GType.FLOAT)) {
            return new GObjectAPI.GParamSpecFloat(ptr);
        }
        if (type.equals((Object)GType.DOUBLE)) {
            return new GObjectAPI.GParamSpecDouble(ptr);
        }
        if (type.equals((Object)GType.STRING)) {
            return new GObjectAPI.GParamSpecString(ptr);
        }
        throw new IllegalArgumentException("Unknown conversion from GType=" + (Object)((Object)type));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClosureProxy
    implements GSignalAPI.GSignalCallbackProxy {
        private final Closure closure;
        private final Method method;
        private final Class<?>[] parameterTypes;
        NativeLong id;

        protected ClosureProxy(String signal, Closure closure) {
            this.closure = closure;
            Method invoke = null;
            Method[] methodArray = closure.getClass().getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals("invoke")) {
                    invoke = m;
                    break;
                }
                ++n2;
            }
            if (invoke == null) {
                throw new IllegalArgumentException(closure.getClass() + " does not have an invoke method");
            }
            invoke.setAccessible(true);
            this.method = invoke;
            this.parameterTypes = new Class[this.method.getParameterTypes().length + 1];
            this.parameterTypes[this.parameterTypes.length - 1] = Pointer.class;
            int i = 0;
            while (i < this.method.getParameterTypes().length) {
                Class<?> paramType;
                Class<Object> nativeType = paramType = this.method.getParameterTypes()[i];
                if (ClockTime.class.isAssignableFrom(paramType)) {
                    nativeType = Long.TYPE;
                } else if (NativeObject.class.isAssignableFrom(paramType)) {
                    nativeType = Pointer.class;
                } else if (Enum.class.isAssignableFrom(paramType)) {
                    nativeType = Integer.TYPE;
                } else if (String.class.isAssignableFrom(paramType)) {
                    nativeType = Pointer.class;
                } else if (Boolean.class.isAssignableFrom(paramType)) {
                    nativeType = Integer.TYPE;
                }
                this.parameterTypes[i] = nativeType;
                ++i;
            }
            NativeLong connectID = GSignalAPI.GSIGNAL_API.g_signal_connect_data(GObject.this, signal, (Callback)this, null, null, 0);
            if (connectID.intValue() == 0) {
                throw new IllegalArgumentException(String.format("Failed to connect signal '%s'", signal));
            }
            this.id = connectID;
        }

        protected synchronized void disconnect() {
            if (this.id != null && this.id.intValue() != 0) {
                GObjectAPI.GOBJECT_API.g_signal_handler_disconnect(GObject.this, this.id);
                this.id = null;
            }
        }

        protected void finalize() {
            this.disconnect();
        }

        public Object callback(Object[] parameters) {
            try {
                Object[] methodParameters = new Object[parameters.length - 1];
                int i = 0;
                while (i < methodParameters.length) {
                    Object nativeParam;
                    Class<?> paramType = this.method.getParameterTypes()[i];
                    Object javaParam = nativeParam = parameters[i];
                    if (nativeParam != null) {
                        javaParam = ClockTime.class.isAssignableFrom(paramType) ? ClockTime.valueOf((Long)nativeParam, TimeUnit.NANOSECONDS) : (NativeObject.class.isAssignableFrom(paramType) ? NativeObject.objectFor((Pointer)nativeParam, paramType, 1, true) : (Enum.class.isAssignableFrom(paramType) ? EnumMapper.getInstance().valueOf((Integer)nativeParam, paramType) : (String.class.isAssignableFrom(paramType) ? ((Pointer)nativeParam).getString(0L) : (Boolean.class.isAssignableFrom(paramType) ? Boolean.valueOf((Integer)nativeParam != 0) : nativeParam))));
                        methodParameters[i] = javaParam;
                    }
                    ++i;
                }
                return this.method.invoke((Object)this.closure, methodParameters);
            }
            catch (Throwable t) {
                return 0;
            }
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }
    }

    protected abstract class GCallback {
        protected final Callback cb;
        protected final NativeLong id;
        volatile boolean connected = false;

        protected GCallback(NativeLong id, Callback cb) {
            this.id = id != null ? id : new NativeLong(0L);
            this.cb = cb;
            this.connected = this.id.intValue() != 0;
        }

        void remove() {
            if (this.connected) {
                this.disconnect();
                this.connected = false;
            }
        }

        protected abstract void disconnect();

        protected final void finalize() {
            this.remove();
        }
    }

    private final class SignalCallback
    extends GCallback {
        protected SignalCallback(String signal, Callback cb) {
            super(GObject.this.g_signal_connect(signal, cb), cb);
            if (!this.connected) {
                throw new IllegalArgumentException(String.format("Failed to connect signal '%s'", signal));
            }
        }

        protected synchronized void disconnect() {
            GObjectAPI.GOBJECT_API.g_signal_handler_disconnect(GObject.this, this.id);
        }
    }
}

