/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import org.gstreamer.Gst;
import org.gstreamer.Structure;
import org.gstreamer.lowlevel.GType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StructureTest {
    private Structure structure;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("StructureTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
        this.structure = new Structure("nazgul");
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"nazgul", (Object)this.structure.getName());
    }

    @Test
    public void testGetValue() {
        this.structure.setValue("uint", GType.UINT, 9);
        Assert.assertEquals((Object)9, (Object)this.structure.getValue("uint"));
        try {
            this.structure.getValue("noexist");
            Assert.fail((String)"Structure.InvalidFieldException should have been thrown");
        }
        catch (Structure.InvalidFieldException invalidFieldException) {
            // empty catch block
        }
        this.structure.setDouble("double", 9.0);
        Assert.assertEquals((Object)9.0, (Object)this.structure.getValue("double"));
        this.structure.setValue("bool", GType.BOOLEAN, true);
        Assert.assertEquals((Object)true, (Object)this.structure.getValue("bool"));
    }

    @Test
    public void testGetInteger() {
        this.structure.setInteger("int", 9);
        Assert.assertEquals((long)9L, (long)this.structure.getInteger("int"));
        this.structure.setInteger("int", -9);
        Assert.assertEquals((long)-9L, (long)this.structure.getInteger("int"));
    }

    @Test
    public void testGetDouble() {
        this.structure.setDouble("double", 9.0);
        Assert.assertEquals((double)9.0, (double)this.structure.getDouble("double"), (double)0.0);
        this.structure.setDouble("double", -9.0);
        Assert.assertEquals((double)-9.0, (double)this.structure.getDouble("double"), (double)0.0);
    }
}

