/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.ptr.LongByReference;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.elements.BaseSrc;
import org.gstreamer.lowlevel.AppAPI;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.NativeObject;

public class AppSrc
extends BaseSrc {
    public static final String GST_NAME = "appsrc";

    private static final AppAPI gst() {
        return AppAPI.APP_API;
    }

    public AppSrc(NativeObject.Initializer init) {
        super(init);
    }

    public void setCaps(Caps caps) {
        AppSrc.gst().gst_app_src_set_caps(this, caps);
    }

    public Caps getCaps() {
        return AppSrc.gst().gst_app_src_get_caps(this);
    }

    public void setSize(long size) {
        AppSrc.gst().gst_app_src_set_size(this, size);
    }

    public long getSize() {
        return AppSrc.gst().gst_app_src_get_size(this);
    }

    public void setStreamType(Type type) {
        AppSrc.gst().gst_app_src_set_stream_type(this, type);
    }

    Type getStreamType(Type type) {
        return AppSrc.gst().gst_app_src_get_stream_type(this);
    }

    public void setMaxBytes(long max) {
        AppSrc.gst().gst_app_src_set_max_bytes(this, max);
    }

    public long getMaxBytes() {
        return AppSrc.gst().gst_app_src_get_max_bytes(this);
    }

    public void setLatency(long min, long max) {
        AppSrc.gst().gst_app_src_set_latency(this, min, max);
    }

    public void getLatency(long[] minmax) {
        LongByReference minRef = new LongByReference();
        LongByReference maxRef = new LongByReference();
        AppSrc.gst().gst_app_src_get_latency(this, minRef, minRef);
        if (minmax == null || minmax.length != 2) {
            minmax = new long[]{minRef.getValue(), maxRef.getValue()};
        }
    }

    public void pushBuffer(Buffer buffer) {
        AppSrc.gst().gst_app_src_push_buffer(this, buffer);
    }

    public void endOfStream() {
        AppSrc.gst().gst_app_src_end_of_stream(this);
    }

    public void connect(final NEED_DATA listener) {
        this.connect(NEED_DATA.class, listener, new GstAPI.GstCallback(){

            public void callback(AppSrc elem, int size) {
                listener.needData(elem, size);
            }
        });
    }

    public void disconnect(NEED_DATA listener) {
        this.disconnect(NEED_DATA.class, listener);
    }

    public void connect(final ENOUGH_DATA listener) {
        this.connect(ENOUGH_DATA.class, listener, new GstAPI.GstCallback(){

            public void callback(AppSrc elem) {
                listener.enoughData(elem);
            }
        });
    }

    public void disconnect(ENOUGH_DATA listener) {
        this.disconnect(ENOUGH_DATA.class, listener);
    }

    public void connect(final SEEK_DATA listener) {
        this.connect(SEEK_DATA.class, listener, new GstAPI.GstCallback(){

            public void callback(AppSrc elem, long position) {
                listener.seekData(elem, position);
            }
        });
    }

    public void disconnect(SEEK_DATA listener) {
        this.disconnect(SEEK_DATA.class, listener);
    }

    public static interface ENOUGH_DATA {
        public void enoughData(AppSrc var1);
    }

    public static interface NEED_DATA {
        public void needData(AppSrc var1, int var2);
    }

    public static interface SEEK_DATA {
        public void seekData(AppSrc var1, long var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STREAM,
        SEEKABLE,
        RANDOM_ACCESS;

    }
}

