/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.FlowReturn;
import org.gstreamer.PadDirection;
import org.gstreamer.PadTemplate;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.lowlevel.BaseSinkAPI;
import org.gstreamer.lowlevel.GObjectAPI;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GstPadTemplateAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomSink
extends BaseSink {
    private static final Logger logger = Logger.getLogger(CustomSink.class.getName());
    private static final Map<Class<? extends CustomSink>, CustomSinkInfo> customSubclasses = new ConcurrentHashMap<Class<? extends CustomSink>, CustomSinkInfo>();
    private static final BooleanFunc1 startCallback = new BooleanFunc1("sinkStart");
    private static final BooleanFunc1 stopCallback = new BooleanFunc1("sinkStop");
    private static final BaseSinkAPI.Render renderCallback = new BaseSinkAPI.Render(){

        public FlowReturn callback(BaseSink sink, Buffer buffer) {
            try {
                return ((CustomSink)sink).sinkRender(buffer);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return FlowReturn.ERROR;
            }
        }
    };
    private static final BaseSinkAPI.Render prerollCallback = new BaseSinkAPI.Render(){

        public FlowReturn callback(BaseSink sink, Buffer buffer) {
            try {
                return ((CustomSink)sink).sinkPreRoll(buffer);
            }
            catch (Throwable ex) {
                return FlowReturn.ERROR;
            }
        }
    };
    private static final BaseSinkAPI.GetCaps getCapsCallback = new BaseSinkAPI.GetCaps(){

        public Caps callback(BaseSink element) {
            try {
                return ((CustomSink)element).sinkGetCaps();
            }
            catch (Throwable ex) {
                return null;
            }
        }
    };
    private static final BaseSinkAPI.SetCaps setCapsCallback = new BaseSinkAPI.SetCaps(){

        public boolean callback(BaseSink element, Caps caps) {
            try {
                return ((CustomSink)element).sinkSetCaps(caps);
            }
            catch (Throwable ex) {
                return false;
            }
        }
    };

    protected CustomSink(Class<? extends CustomSink> subClass, String name) {
        super(CustomSink.initializer(GObjectAPI.GOBJECT_API.g_object_new(CustomSink.getSubclassType(subClass), "name", name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CustomSinkInfo getSubclassInfo(Class<? extends CustomSink> subClass) {
        Class<? extends CustomSink> clazz = subClass;
        synchronized (clazz) {
            CustomSinkInfo info = customSubclasses.get(subClass);
            if (info == null) {
                CustomSink.init(subClass);
                info = customSubclasses.get(subClass);
            }
            return info;
        }
    }

    private static GType getSubclassType(Class<? extends CustomSink> subClass) {
        return CustomSink.getSubclassInfo(subClass).type;
    }

    @SinkCallback
    protected FlowReturn sinkRender(Buffer buffer) throws IOException {
        logger.info(String.valueOf(this.getClass().getSimpleName()) + ".sinkRender");
        return FlowReturn.WRONG_STATE;
    }

    @SinkCallback
    protected FlowReturn sinkPreRoll(Buffer buffer) throws IOException {
        logger.info(String.valueOf(this.getClass().getSimpleName()) + ".sinkPreRoll");
        return FlowReturn.WRONG_STATE;
    }

    @SinkCallback
    protected boolean sinkStart() {
        logger.info(String.valueOf(this.getClass().getSimpleName()) + ".sinkStart");
        return false;
    }

    @SinkCallback
    protected boolean sinkStop() {
        logger.info(String.valueOf(this.getClass().getSimpleName()) + ".sinkStop");
        return false;
    }

    @SinkCallback
    protected Caps sinkGetCaps() {
        logger.info(String.valueOf(this.getClass().getSimpleName()) + ".sinkGetCaps");
        return null;
    }

    @SinkCallback
    protected boolean sinkSetCaps(Caps caps) {
        logger.info(String.valueOf(this.getClass().getSimpleName()) + ".sinkSetCaps");
        return false;
    }

    private static void init(Class<? extends CustomSink> sinkClass) {
        final CustomSinkInfo info = new CustomSinkInfo();
        customSubclasses.put(sinkClass, info);
        Method[] methodArray = CustomSink.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            SinkCallback cb = m.getAnnotation(SinkCallback.class);
            if (cb != null) {
                try {
                    Method sinkMethod = sinkClass.getDeclaredMethod(m.getName(), m.getParameterTypes());
                    if (!sinkMethod.equals(m)) {
                        String name = m.getName().toLowerCase().substring("sink".length());
                        if (name.equals("render")) {
                            info.render = renderCallback;
                        } else if (name.equals("preroll")) {
                            info.preroll = prerollCallback;
                        } else if (name.equals("start")) {
                            info.start = startCallback;
                        } else if (name.equals("stop")) {
                            info.stop = stopCallback;
                        } else if (name.equals("getcaps")) {
                            info.getCaps = getCapsCallback;
                        } else if (name.equals("setcaps")) {
                            info.setCaps = setCapsCallback;
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        info.classInit = new GObjectAPI.GClassInitFunc(){

            public void callback(Pointer g_class, Pointer class_data) {
                BaseSinkAPI.GstBaseSinkClass base = new BaseSinkAPI.GstBaseSinkClass(g_class);
                base.render = info.render;
                base.preroll = info.preroll;
                base.start = info.start;
                base.stop = info.stop;
                base.write();
            }
        };
        info.baseInit = new GObjectAPI.GBaseInitFunc(){

            public void callback(Pointer g_class) {
                info.caps = Caps.anyCaps();
                info.template = new PadTemplate("sink", PadDirection.SINK, info.caps);
                GstPadTemplateAPI.GSTPADTEMPLATE_API.gst_element_class_add_pad_template(g_class, info.template);
            }
        };
        GObjectAPI.GTypeInfo ginfo = new GObjectAPI.GTypeInfo();
        ginfo.class_init = info.classInit;
        ginfo.base_init = info.baseInit;
        ginfo.instance_init = null;
        ginfo.class_size = (short)new BaseSinkAPI.GstBaseSinkClass().size();
        ginfo.instance_size = (short)new BaseSinkAPI.GstBaseSinkStruct().size();
        info.type = GObjectAPI.GOBJECT_API.g_type_register_static(BaseSinkAPI.BASESINK_API.gst_base_sink_get_type(), sinkClass.getSimpleName(), ginfo, 0);
    }

    private static class BooleanFunc1
    implements BaseSinkAPI.BooleanFunc1 {
        private Method method;

        public BooleanFunc1(String methodName) {
            try {
                this.method = CustomSink.class.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean callback(BaseSink element) {
            try {
                return (Boolean)this.method.invoke((Object)element, new Object[0]);
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }

    private static class CustomSinkInfo {
        GType type;
        PadTemplate template;
        Caps caps;
        GObjectAPI.GClassInitFunc classInit;
        GObjectAPI.GBaseInitFunc baseInit;
        BaseSinkAPI.Render render;
        BaseSinkAPI.Render preroll;
        BaseSinkAPI.BooleanFunc1 start;
        BaseSinkAPI.BooleanFunc1 stop;
        BaseSinkAPI.GetCaps getCaps;
        BaseSinkAPI.SetCaps setCaps;

        private CustomSinkInfo() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface SinkCallback {
    }
}

