/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.ByteBuffer;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pipeline;
import org.gstreamer.elements.AppSink;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class DataAppSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private final AppSink sink;
    private boolean passDirectBuffer = false;
    private Listener listener;

    public DataAppSink(String name, Listener listener) {
        super(DataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.sink = (AppSink)ElementFactory.make("appsink", "DataSink");
        this.sink.set("emit-signals", true);
        this.sink.set("sync", true);
        this.sink.connect(new AppSinkNewBufferListener());
        Element conv = ElementFactory.make("identity", "Data");
        this.addMany(conv, this.sink);
        Element.linkMany(conv, this.sink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public DataAppSink(String name, Pipeline pipeline, Listener listener) {
        super(DataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        Element element = pipeline.getElementByName("DataSink");
        if (element == null) {
            this.sink = null;
            throw new RuntimeException("Element with name DataSink not found in the pipeline");
        }
        this.sink = (AppSink)element;
        this.sink.set("emit-signals", true);
        this.sink.set("sync", true);
        this.sink.connect(new AppSinkNewBufferListener());
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setPassDirectBuffer(boolean passThru) {
        this.passDirectBuffer = passThru;
    }

    public BaseSink getSinkElement() {
        return this.sink;
    }

    public Caps getCaps() {
        return this.sink.getCaps();
    }

    class AppSinkNewBufferListener
    implements AppSink.NEW_BUFFER {
        AppSinkNewBufferListener() {
        }

        public void newBuffer(AppSink elem) {
            ByteBuffer data;
            Buffer buffer = DataAppSink.this.sink.pullBuffer();
            Caps caps = buffer.getCaps();
            int n = buffer.getSize();
            if (n < 1) {
                return;
            }
            if (DataAppSink.this.passDirectBuffer) {
                data = buffer.getByteBuffer();
            } else {
                data = ByteBuffer.allocate(n);
                data.put(buffer.getByteBuffer()).flip();
            }
            DataAppSink.this.listener.dataFrame(caps, n, data);
            buffer.dispose();
        }
    }

    public static interface Listener {
        public void dataFrame(Caps var1, int var2, ByteBuffer var3);
    }
}

