/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.gstreamer.Bus;
import org.gstreamer.ElementFactory;
import org.gstreamer.Message;
import org.gstreamer.Structure;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.swing.OSXVideoComponent;

public class OSXVideoSink
extends BaseSink {
    public static final String GST_NAME = "osxvideosink";
    private final ArrayList<Listener> listeners = new ArrayList();

    static {
        ElementFactory.registerElement(OSXVideoSink.class, GST_NAME);
    }

    public OSXVideoSink(String name) {
        this(OSXVideoSink.makeRawElement(GST_NAME, name));
        this.set("embed", true);
        this.setQOSEnabled(false);
    }

    public OSXVideoSink(NativeObject.Initializer init) {
        super(init);
        this.setQOSEnabled(false);
    }

    public void setEmbedded(boolean embed) {
        this.set("embed", true);
    }

    public boolean isEmbedded() {
        return (Boolean)this.get("embed");
    }

    public void listenForNewViews(Bus bus) {
        bus.connect(new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message message) {
                Structure structure;
                if (message.getSource().getNativeAddress().equals((Object)OSXVideoSink.this.getNativeAddress()) && (structure = message.getStructure()) != null && "have-ns-view".equals(structure.getName())) {
                    Pointer nsview = (Pointer)structure.getValue("nsview");
                    OSXVideoSink.this.fireNewVideoComponent(nsview);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener l) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener l) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    private void fireNewVideoComponent(final Pointer nsview) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OSXVideoComponent osxVideoComponent = new OSXVideoComponent(nsview);
                ArrayList arrayList = OSXVideoSink.this.listeners;
                synchronized (arrayList) {
                    for (Listener l : OSXVideoSink.this.listeners) {
                        l.newVideoComponent(this, osxVideoComponent);
                    }
                }
            }
        });
    }

    public static interface Listener {
        public void newVideoComponent(Object var1, OSXVideoComponent var2);
    }
}

