/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Fraction;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Video;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.NativeObject;

public class PlayBin2
extends Pipeline {
    public static final String GST_NAME = "playbin2";

    public PlayBin2(String name) {
        this(PlayBin2.makeRawElement(GST_NAME, name));
    }

    public PlayBin2(String name, URI uri) {
        this(name);
        this.setURI(uri);
    }

    public PlayBin2(NativeObject.Initializer init) {
        super(init);
    }

    public void setInputFile(File file) {
        this.setURI(file.toURI());
    }

    public void setURI(URI uri) {
        this.set("uri", uri);
    }

    public void setAudioSink(Element element) {
        this.setElement("audio-sink", element);
    }

    public void setVideoSink(Element element) {
        this.setElement("video-sink", element);
    }

    public void setVisualization(Element element) {
        this.setElement("vis-plugin", element);
    }

    private void setElement(String key, Element element) {
        if (element == null) {
            element = ElementFactory.make("fakesink", "fake-" + key);
        }
        this.set(key, element);
    }

    public void setVolumePercent(int percent) {
        this.setVolume(Math.max(Math.min((double)percent, 100.0), 0.0) / 100.0);
    }

    public int getVolumePercent() {
        return (int)(this.getVolume() * 100.0 + 0.5);
    }

    public void setVolume(double volume) {
        this.set("volume", volume);
    }

    public double getVolume() {
        return ((Number)this.get("volume")).doubleValue();
    }

    public double getVideoSinkFrameRate() {
        for (Element sink : this.getSinks()) {
            for (Pad pad : sink.getPads()) {
                Fraction frameRate = Video.getVideoFrameRate(pad);
                if (frameRate == null) continue;
                return frameRate.toDouble();
            }
        }
        return 0.0;
    }

    public Dimension getVideoSize() {
        for (Element sink : this.getSinks()) {
            for (Pad pad : sink.getPads()) {
                Dimension size = Video.getVideoSize(pad);
                if (size == null) continue;
                return size;
            }
        }
        return null;
    }

    public void connect(final ABOUT_TO_FINISH listener) {
        this.connect(ABOUT_TO_FINISH.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem) {
                listener.aboutToFinish(elem);
            }
        });
    }

    public void disconnect(ABOUT_TO_FINISH listener) {
        this.disconnect(ABOUT_TO_FINISH.class, listener);
    }

    public void connect(final VIDEO_CHANGED listener) {
        this.connect(VIDEO_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem) {
                listener.videoChanged(elem);
            }
        });
    }

    public void disconnect(VIDEO_CHANGED listener) {
        this.disconnect(VIDEO_CHANGED.class, listener);
    }

    public void connect(final AUDIO_CHANGED listener) {
        this.connect(AUDIO_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem) {
                listener.audioChanged(elem);
            }
        });
    }

    public void disconnect(AUDIO_CHANGED listener) {
        this.disconnect(AUDIO_CHANGED.class, listener);
    }

    public void connect(final TEXT_CHANGED listener) {
        this.connect(TEXT_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem) {
                listener.textChanged(elem);
            }
        });
    }

    public void disconnect(TEXT_CHANGED listener) {
        this.disconnect(TEXT_CHANGED.class, listener);
    }

    public void connect(final VIDEO_TAGS_CHANGED listener) {
        this.connect(VIDEO_TAGS_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem, int stream) {
                listener.videoTagsChanged(elem, stream);
            }
        });
    }

    public void disconnect(VIDEO_TAGS_CHANGED listener) {
        this.disconnect(VIDEO_TAGS_CHANGED.class, listener);
    }

    public void connect(final AUDIO_TAGS_CHANGED listener) {
        this.connect(AUDIO_TAGS_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem, int stream) {
                listener.audioTagsChanged(elem, stream);
            }
        });
    }

    public void disconnect(AUDIO_TAGS_CHANGED listener) {
        this.disconnect(AUDIO_TAGS_CHANGED.class, listener);
    }

    public void connect(final TEXT_TAGS_CHANGED listener) {
        this.connect(TEXT_TAGS_CHANGED.class, listener, new GstAPI.GstCallback(){

            public void callback(PlayBin2 elem, int stream) {
                listener.textTagsChanged(elem, stream);
            }
        });
    }

    public void disconnect(TEXT_TAGS_CHANGED listener) {
        this.disconnect(TEXT_TAGS_CHANGED.class, listener);
    }

    public static interface ABOUT_TO_FINISH {
        public void aboutToFinish(PlayBin2 var1);
    }

    public static interface AUDIO_CHANGED {
        public void audioChanged(PlayBin2 var1);
    }

    public static interface AUDIO_TAGS_CHANGED {
        public void audioTagsChanged(PlayBin2 var1, int var2);
    }

    public static interface TEXT_CHANGED {
        public void textChanged(PlayBin2 var1);
    }

    public static interface TEXT_TAGS_CHANGED {
        public void textTagsChanged(PlayBin2 var1, int var2);
    }

    public static interface VIDEO_CHANGED {
        public void videoChanged(PlayBin2 var1);
    }

    public static interface VIDEO_TAGS_CHANGED {
        public void videoTagsChanged(PlayBin2 var1, int var2);
    }
}

