/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.AppSink;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class RGBDataAppSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private final AppSink sink;
    private boolean passDirectBuffer = false;
    private Listener listener;

    public RGBDataAppSink(String name, Listener listener) {
        super(RGBDataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.sink = (AppSink)ElementFactory.make("appsink", "VideoSink");
        this.sink.set("emit-signals", true);
        this.sink.set("sync", true);
        this.sink.connect(new AppSinkNewBufferListener());
        Element conv = ElementFactory.make("ffmpegcolorspace", "ColorConverter");
        Element videofilter = ElementFactory.make("capsfilter", "ColorFilter");
        StringBuilder caps = new StringBuilder("video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ");
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            caps.append("red_mask=(int)0xFF00, green_mask=(int)0xFF0000, blue_mask=(int)0xFF000000");
        } else {
            caps.append("red_mask=(int)0xFF0000, green_mask=(int)0xFF00, blue_mask=(int)0xFF");
        }
        videofilter.setCaps(new Caps(caps.toString()));
        this.addMany(conv, videofilter, this.sink);
        Element.linkMany(conv, videofilter, this.sink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public RGBDataAppSink(String name, Pipeline pipeline, Listener listener) {
        super(RGBDataAppSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        Element element = pipeline.getElementByName("VideoSink");
        if (element == null) {
            this.sink = null;
            throw new RuntimeException("Element with name VideoSink not found in the pipeline");
        }
        this.sink = (AppSink)element;
        this.sink.set("emit-signals", true);
        this.sink.set("sync", true);
        this.sink.connect(new AppSinkNewBufferListener());
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setPassDirectBuffer(boolean passThru) {
        this.passDirectBuffer = passThru;
    }

    public BaseSink getSinkElement() {
        return this.sink;
    }

    public Caps getCaps() {
        return this.sink.getCaps();
    }

    class AppSinkNewBufferListener
    implements AppSink.NEW_BUFFER {
        AppSinkNewBufferListener() {
        }

        public void newBuffer(AppSink elem) {
            IntBuffer rgb;
            Buffer buffer = RGBDataAppSink.this.sink.pullBuffer();
            Caps caps = buffer.getCaps();
            Structure struct = caps.getStructure(0);
            int width = struct.getInteger("width");
            int height = struct.getInteger("height");
            if (width < 1 || height < 1) {
                return;
            }
            if (RGBDataAppSink.this.passDirectBuffer) {
                rgb = buffer.getByteBuffer().asIntBuffer();
            } else {
                rgb = IntBuffer.allocate(width * height);
                rgb.put(buffer.getByteBuffer().asIntBuffer()).flip();
            }
            RGBDataAppSink.this.listener.rgbFrame(width, height, rgb);
            buffer.dispose();
        }
    }

    public static interface Listener {
        public void rgbFrame(int var1, int var2, IntBuffer var3);
    }
}

