/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.elements.AppSrc;
import org.gstreamer.swing.VideoComponent;

public class AppSrcTest {
    private static Pipeline pipeline;
    static TagList tags;

    public static void main(String[] args) {
        args = Gst.init("AppSrcTest", args);
        int width = 320;
        int height = 200;
        pipeline = new Pipeline("pipeline");
        final AppSrc appsrc = (AppSrc)ElementFactory.make("appsrc", "source");
        final Element srcfilter = ElementFactory.make("capsfilter", "srcfilter");
        Caps fltcaps = new Caps("video/x-raw-rgb, framerate=2/1, width=320, height=200, bpp=16, depth=16");
        srcfilter.setCaps(fltcaps);
        final Element videorate = ElementFactory.make("videorate", "videorate");
        final Element ratefilter = ElementFactory.make("capsfilter", "RateFilter");
        ratefilter.setCaps(Caps.fromString("video/x-raw-rgb, framerate=2/1"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("FakeSrcTest");
                VideoComponent panel = new VideoComponent();
                panel.setPreferredSize(new Dimension(320, 200));
                frame.add((Component)panel, "Center");
                Element videosink = panel.getElement();
                pipeline.addMany(appsrc, srcfilter, videorate, ratefilter, videosink);
                Element.linkMany(appsrc, srcfilter, videorate, ratefilter, videosink);
                appsrc.set("emit-signals", true);
                appsrc.connect(new AppSrc.NEED_DATA(){
                    byte color = 0;
                    byte[] data = new byte[128000];

                    public void needData(AppSrc elem, int size) {
                        System.out.println("NEED_DATA: Element=" + elem.getNativeAddress() + " size=" + size);
                        byte by = this.color;
                        this.color = (byte)(by + 1);
                        Arrays.fill(this.data, by);
                        Buffer buffer = new Buffer(this.data.length);
                        buffer.getByteBuffer().put(this.data);
                        appsrc.pushBuffer(buffer);
                    }
                });
                appsrc.connect(new AppSrc.ENOUGH_DATA(){

                    public void enoughData(AppSrc elem) {
                        System.out.println("NEED_DATA: Element=" + elem.getNativeAddress());
                    }
                });
                frame.setSize(640, 480);
                frame.pack();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
                pipeline.setState(State.PLAYING);
            }
        });
    }
}

