/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.io.FileInputStream;
import org.gstreamer.Bin;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.TagList;
import org.gstreamer.elements.DecodeBin2;
import org.gstreamer.io.InputStreamSrc;

public class InputStreamSrcTest {
    static final String name = "InputStreamSrcTest";

    public static void main(String[] args) {
        if ((args = Gst.init(name, args)).length < 1) {
            System.err.println("Usage: InputStreamSrcTest <filename>");
            System.exit(1);
        }
        InputStreamSrc src = null;
        try {
            FileInputStream srcFile = new FileInputStream(args[0]);
            src = new InputStreamSrc(srcFile, "input file");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        DecodeBin2 decodeBin = (DecodeBin2)ElementFactory.make("decodebin2", "Decode Bin");
        Pipeline pipe = new Pipeline("main pipeline");
        pipe.addMany(src, decodeBin);
        src.link((Element)decodeBin);
        final Bin audioBin = new Bin("Audio Bin");
        Element conv = ElementFactory.make("audioconvert", "Audio Convert");
        Element sink = ElementFactory.make("autoaudiosink", "sink");
        audioBin.addMany(conv, sink);
        Element.linkMany(conv, sink);
        audioBin.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
        pipe.add(audioBin);
        decodeBin.connect(new DecodeBin2.NEW_DECODED_PAD(){

            public void newDecodedPad(DecodeBin2 elem, Pad pad, boolean last) {
                Pad audioPad = audioBin.getStaticPad("sink");
                if (pad.isLinked()) {
                    return;
                }
                Caps caps = pad.getCaps();
                Structure struct = caps.getStructure(0);
                if (struct.getName().startsWith("audio/")) {
                    System.out.println("Got audio pad");
                    pad.link(audioPad);
                }
            }
        });
        Bus bus = pipe.getBus();
        bus.connect(new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                System.out.println("Got TAG event");
                for (String tag : tagList.getTagNames()) {
                    System.out.println("Tag " + tag + " = " + tagList.getValue(tag, 0));
                }
            }
        });
        bus.connect(new Bus.ERROR(){

            public void errorMessage(GstObject source, int code, String message) {
                System.out.println("Error: code=" + code + " message=" + message);
            }
        });
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject source) {
                System.out.println("Got EOS!");
            }
        });
        pipe.play();
        Gst.main();
    }
}

