/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.swing.VideoComponent;

public class NavigationTest {
    private static Pipeline pipeline;
    private static final int width = 720;
    private static final int height = 576;

    public static void main(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        args = Gst.init("SwingVideoTest", args);
        System.out.println("Creating MainLoop");
        System.out.println("Creating pipeline");
        pipeline = new Pipeline("pipeline");
        System.out.println("Pipeline created");
        System.out.flush();
        System.out.println("Creating videotestsrc");
        final Element fakesrc = ElementFactory.make("videotestsrc", "source");
        System.out.println("Creating capsfilter");
        final Element flt = ElementFactory.make("capsfilter", "flt");
        System.out.println("Creating caps");
        Caps fltcaps = new Caps("video/x-raw-yuv, width=720, height=576, bpp=32, depth=24, framerate=30/1");
        System.out.println("Setting caps");
        flt.setCaps(fltcaps);
        final Element navtest = ElementFactory.make("navigationtest", "navtest");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println("Creating GstVideoComponent");
                final VideoComponent videoComponent = new VideoComponent();
                videoComponent.setPreferredSize(new Dimension(720, 576));
                JFrame frame = new JFrame("Swing Video Test");
                frame.add((Component)videoComponent, "Center");
                frame.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent evt) {
                        KeyListener[] keyListenerArray = videoComponent.getKeyListeners();
                        int n = keyListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            KeyListener l = keyListenerArray[n2];
                            l.keyPressed(evt);
                            ++n2;
                        }
                    }

                    public void keyReleased(KeyEvent evt) {
                        KeyListener[] keyListenerArray = videoComponent.getKeyListeners();
                        int n = keyListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            KeyListener l = keyListenerArray[n2];
                            l.keyReleased(evt);
                            ++n2;
                        }
                    }
                });
                Element videosink = videoComponent.getElement();
                System.out.println("Adding elements to pipeline");
                pipeline.addMany(fakesrc, flt, navtest, videosink);
                Element.linkMany(fakesrc, flt, navtest, videosink);
                pipeline.setState(State.PLAYING);
                frame.setSize(720, 576);
                frame.pack();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }
}

