/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import com.sun.jna.Platform;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Bus;
import org.gstreamer.BusSyncReply;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Message;
import org.gstreamer.Structure;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.event.BusSyncHandler;
import org.gstreamer.interfaces.XOverlay;

public class OverlayPlayer {
    private static Bus bus;

    public static void main(String[] args) {
        if ((args = Gst.init("Swing Player", args)).length < 1) {
            System.err.println("Usage: SwingPlayer <filename>");
            System.exit(1);
        }
        final String file = args[0];
        final String overlayFactory = Platform.isWindows() ? "directdrawsink" : "xvimagesink";
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("Overlay Test");
                final Canvas canvas = new Canvas();
                canvas.setPreferredSize(new Dimension(640, 480));
                frame.add((Component)canvas, "Center");
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
                PlayBin2 player = new PlayBin2("Overlay Player");
                player.setInputFile(new File(file));
                OverlayPlayer.bus = player.getBus();
                bus.connect(new Bus.ERROR(){

                    public void errorMessage(GstObject source, int code, String message) {
                        System.out.println("Error: code=" + code + " message=" + message);
                    }
                });
                final Element videoSink = ElementFactory.make(overlayFactory, "overlay video sink");
                player.setVideoSink(videoSink);
                if (!Platform.isWindows()) {
                    bus.setSyncHandler(new BusSyncHandler(){

                        public BusSyncReply syncMessage(Message msg) {
                            Structure s = msg.getStructure();
                            if (s == null || !s.hasName("prepare-xwindow-id")) {
                                return BusSyncReply.PASS;
                            }
                            XOverlay.wrap(videoSink).setWindowHandle(canvas);
                            return BusSyncReply.DROP;
                        }
                    });
                } else {
                    XOverlay.wrap(videoSink).setWindowHandle(canvas);
                }
                player.play();
            }
        });
    }
}

