/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.util.List;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.interfaces.Tuner;
import org.gstreamer.interfaces.TunerChannel;
import org.gstreamer.interfaces.TunerNorm;

public class TunerTest {
    public static void main(String[] args) {
        args = Gst.init("ColorBalance video test", args);
        Pipeline pipe = new Pipeline("pipeline");
        Element videosrc = ElementFactory.make("v4l2src", "source");
        videosrc.set("device", "/dev/video0");
        Element videosink = ElementFactory.make("xvimagesink", "xv");
        pipe.addMany(videosrc, videosink);
        Element.linkMany(videosrc, videosink);
        pipe.setState(State.PLAYING);
        Tuner tun = Tuner.wrap(videosrc);
        List<TunerNorm> normList = tun.getNormList();
        for (TunerNorm n : normList) {
            System.out.println("Available norm: " + n.getLabel());
        }
        List<TunerChannel> chList = tun.getChannelList();
        for (TunerChannel ch : chList) {
            System.out.println("Channel [" + ch.getLabel() + "]: " + ch.isTuningChannel());
        }
        int i = 0;
        while (true) {
            tun.setChannel(chList.get(i % chList.size()));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }
}

