/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import java.util.HashMap;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.lowlevel.GNative;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GstElementFactoryAPI;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GValueTest {
    private static final GValueAPI api = GValueAPI.GVALUE_API;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("GValueTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testInt() throws Exception {
        GValueAPI.GValue v = new GValueAPI.GValue();
        api.g_value_init(v, GType.INT);
        api.g_value_set_int(v, 5);
        Assert.assertEquals((String)"int value mismatch", (Object)5, (Object)v.getValue());
        api.g_value_set_int(v, 6);
        Assert.assertEquals((String)"int value mismatch", (Object)6, (Object)v.getValue());
        Assert.assertTrue((String)"type mismatch", (boolean)(v.getValue() instanceof Integer));
    }

    @Test
    public void testObjectPtrRef() throws Exception {
        Element e = ElementFactory.make("fakesink", "fakesink");
        GValueAPI.GValue v = new GValueAPI.GValue();
        api.g_value_init(v, GType.OBJECT);
        api.g_value_set_object(v, e);
        Object obj = v.getValue();
        Assert.assertTrue((String)"type mismatch", (boolean)(obj instanceof Element));
        Assert.assertEquals((String)"object mismatch", (Object)e, (Object)obj);
    }

    @Test
    public void testObjectTypeMap() throws Exception {
        ElementFactory factory = GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_find("videotestsrc");
        Pointer p = GstElementFactoryAPI.GSTELEMENTFACTORY_API.ptr_gst_element_factory_create(factory, "videotestsrc");
        GValueAPI.GValue v = new GValueAPI.GValue();
        api.g_value_init(v, GType.OBJECT);
        GValueTestAPI.API.g_value_set_object(v.getPointer(), p);
        Object obj = v.getValue();
        Assert.assertTrue((String)"type mismatch", (boolean)(obj instanceof Element));
    }

    public static interface GValueTestAPI
    extends Library {
        public static final GValueTestAPI API = GNative.loadLibrary("gobject-2.0", GValueTestAPI.class, new HashMap<String, Object>(){});

        public void g_value_set_object(Pointer var1, Pointer var2);

        public Pointer g_value_get_object(Pointer var1);
    }
}

