/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Native;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.Version;
import org.gstreamer.swing.VideoComponent;
import org.gstreamer.swing.VideoPlayer;

public class Main {
    static Pipeline pipe;

    static void diagnostics(String[] args) {
        String implVersion;
        String version;
        Package pkg = Native.class.getPackage();
        String title = pkg.getSpecificationTitle();
        if (title == null) {
            title = "JNA";
        }
        if ((version = pkg.getSpecificationVersion()) == null) {
            version = "Cannot determine version - no package information present";
        }
        if ((implVersion = pkg.getImplementationVersion()) == null) {
            implVersion = "unknown";
        }
        String jnaVersion = String.format(String.valueOf(title) + " API=%s Version=%s\n", version, implVersion);
        String PREFIX = "DIAG: ";
        System.out.flush();
        System.out.println("DIAG: " + jnaVersion);
        args = Gst.init("unknown", args);
        Version v = Gst.getVersion();
        System.out.println("DIAG: Gst.init succeeded. gstreamer version " + v);
        System.out.flush();
        pipe = new Pipeline();
        if (pipe == null) {
            throw new RuntimeException("Failed to create Pipeline");
        }
        System.out.println("DIAG: Pipeline created successfully");
        System.out.flush();
        final Element videosrc = ElementFactory.make("videotestsrc", "source");
        System.out.println("DIAG: videotestsrc created successfully");
        System.out.flush();
        final Element videofilter = ElementFactory.make("capsfilter", "flt");
        System.out.println("DIAG: capsfilter created successfully");
        System.out.flush();
        int width = 400;
        int height = 300;
        videofilter.setCaps(Caps.fromString("video/x-raw-yuv, width=400, height=300, bpp=32, depth=32, framerate=25/1"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VideoComponent videoComponent = new VideoComponent();
                System.out.println("DIAG: VideoComponent created successfully");
                System.out.flush();
                Element videosink = videoComponent.getElement();
                pipe.addMany(videosrc, videofilter, videosink);
                Element.linkMany(videosrc, videofilter, videosink);
                JFrame frame = new JFrame("Swing Video Test");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)videoComponent, "Center");
                videoComponent.setPreferredSize(new Dimension(400, 300));
                frame.pack();
                frame.setVisible(true);
                pipe.setState(State.PLAYING);
                System.out.println("DIAG: pipeline set to PLAYING state");
                System.out.flush();
            }
        });
    }

    private static void play(String[] args) {
        args = Gst.init("gstreamer-java", args);
        final LinkedList<URI> playList = new LinkedList<URI>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            playList.add(new File(arg).toURI());
            ++n2;
        }
        final String file = args[0];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("Swing Test");
                VideoPlayer player = new VideoPlayer(file);
                player.setPreferredSize(new Dimension(640, 480));
                player.setControlsVisible(true);
                player.getMediaPlayer().setPlaylist(playList);
                frame.add((Component)player, "Center");
                player.getMediaPlayer().play();
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        String jnaPath = System.getProperty("jna.library.path");
        if (jnaPath == null) {
            System.setProperty("jna.library.path", "/usr/share/java:/opt/local/lib:/usr/local/lib:/usr/lib");
        }
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        if (args.length == 0) {
            Main.diagnostics(args);
        } else {
            Main.play(args);
        }
    }
}

