/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.media;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.gstreamer.Element;
import org.gstreamer.State;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.media.PipelineMediaPlayer;

public class PlayBinMediaPlayer
extends PipelineMediaPlayer {
    private static final Executor defaultExec = Executors.newSingleThreadExecutor();
    private final PlayBin2 playbin = (PlayBin2)this.getPipeline();

    public PlayBinMediaPlayer(String name, Executor eventExecutor) {
        super(new PlayBin2(name), eventExecutor);
    }

    public PlayBinMediaPlayer() {
        this("VideoPlayer", defaultExec);
    }

    public void setAudioSink(Element sink) {
        this.playbin.setAudioSink(sink);
    }

    public void setVideoSink(Element sink) {
        this.playbin.setVideoSink(sink);
    }

    public boolean isPlaying() {
        return this.playbin.isPlaying();
    }

    public void pause() {
        if (this.playbin.isPlaying()) {
            this.playbin.pause();
        }
    }

    public void play() {
        if (!this.playbin.isPlaying()) {
            this.playbin.play();
        }
    }

    public void stop() {
        this.playbin.stop();
    }

    public void setURI(URI uri) {
        State old = this.playbin.getState();
        this.playbin.setState(State.READY);
        this.playbin.setURI(uri);
        this.playbin.setState(old);
    }

    public void setInputFile(File file) {
        this.setURI(file.toURI());
    }

    public void setVolume(double volume) {
        this.playbin.setVolume(volume);
    }

    public double getVolume() {
        return this.playbin.getVolume();
    }

    protected static URI parseURI(String uri) {
        try {
            URI u = new URI(uri);
            if (u.getScheme() == null) {
                throw new URISyntaxException(uri, "Invalid URI scheme");
            }
            return u;
        }
        catch (URISyntaxException e) {
            File f = new File(uri);
            if (!f.exists()) {
                throw new IllegalArgumentException("Invalid URI/file " + uri, e);
            }
            return f.toURI();
        }
    }
}

