/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt.overlay;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.platform.unix.X11;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.gstreamer.BusSyncReply;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GstException;
import org.gstreamer.Message;
import org.gstreamer.MessageType;
import org.gstreamer.Structure;
import org.gstreamer.event.BusSyncHandler;
import org.gstreamer.swt.overlay.SWTOverlay;

public class VideoComponent
extends Canvas
implements BusSyncHandler,
DisposeListener {
    private static int counter = 0;
    private final Element videosink;
    private final SWTOverlay overlay;
    private boolean watcherRunning = false;

    public VideoComponent(Composite parent, int style, boolean enableX11Events) {
        super(parent, style | 0x1000000);
        String name;
        String string = Platform.isLinux() ? "xvimagesink" : (Platform.isWindows() ? "d3dvideosink" : (name = Platform.isMac() ? "osxvideosink" : null));
        if (name == null) {
            throw new GstException("Platform not supported");
        }
        this.videosink = ElementFactory.make(name, "OverlayVideoComponent" + counter++);
        this.overlay = SWTOverlay.wrap(this.videosink);
        this.overlay.setWindowHandle((Composite)this);
        this.enableX11Events(enableX11Events);
        this.expose();
    }

    public synchronized void enableX11Events(boolean enable) {
        if (enable && Platform.isLinux()) {
            this.videosink.set("handle-events", !enable);
            this.overlay.handleEvent(!enable);
            this.watcherRunning = true;
            new Thread(){

                public void run() {
                    try {
                        X11 x11 = X11.INSTANCE;
                        X11.Display display = x11.XOpenDisplay(null);
                        X11.Window window = new X11.Window(SWTOverlay.getLinuxHandle((Composite)VideoComponent.this));
                        x11.XSelectInput(display, window, new NativeLong(2326576L));
                        while (VideoComponent.this.watcherRunning) {
                            final X11.XEvent xEvent = new X11.XEvent();
                            x11.XNextEvent(display, xEvent);
                            if (!VideoComponent.this.watcherRunning || VideoComponent.this.isDisposed()) continue;
                            VideoComponent.this.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (VideoComponent.this.watcherRunning && !VideoComponent.this.isDisposed()) {
                                        Event swtEvent = new Event();
                                        switch (xEvent.type) {
                                            case 7: {
                                                X11.XCrossingEvent ce = (X11.XCrossingEvent)xEvent.readField("xcrossing");
                                                swtEvent.x = ce.x;
                                                swtEvent.y = ce.y;
                                                VideoComponent.this.notifyListeners(6, swtEvent);
                                                break;
                                            }
                                            case 8: {
                                                X11.XCrossingEvent ce = (X11.XCrossingEvent)xEvent.readField("xcrossing");
                                                swtEvent.x = ce.x;
                                                swtEvent.y = ce.y;
                                                VideoComponent.this.notifyListeners(7, swtEvent);
                                                break;
                                            }
                                            default: {
                                                VideoComponent.this.overlay.expose();
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        x11.XCloseDisplay(display);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            this.addDisposeListener(this);
        }
    }

    public VideoComponent(Composite parent, int style) {
        this(parent, style, false);
    }

    public void widgetDisposed(DisposeEvent arg0) {
        this.watcherRunning = false;
        this.removeDisposeListener(this);
    }

    public void expose() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!VideoComponent.this.isDisposed()) {
                    VideoComponent.this.overlay.expose();
                }
            }
        });
    }

    public void setKeepAspect(boolean keepAspect) {
        this.videosink.set("force-aspect-ratio", keepAspect);
    }

    public Element getElement() {
        return this.videosink;
    }

    public long handle() {
        return SWTOverlay.handle((Composite)this);
    }

    public BusSyncReply syncMessage(Message message) {
        if (message.getType() != MessageType.ELEMENT) {
            return BusSyncReply.PASS;
        }
        Structure s = message.getStructure();
        if (s == null || !s.hasName("prepare-xwindow-id")) {
            return BusSyncReply.PASS;
        }
        this.overlay.setWindowHandle((Composite)this);
        return BusSyncReply.DROP;
    }
}

