/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import peasy.CameraState;
import peasy.DampedAction;
import peasy.InterpolationManager;
import peasy.InterpolationUtil;
import peasy.PeasyDragHandler;
import peasy.org.apache.commons.math.geometry.CardanEulerSingularityException;
import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.RotationOrder;
import peasy.org.apache.commons.math.geometry.Vector3D;
import processing.core.PApplet;
import processing.core.PMatrix3D;

public class PeasyCam {
    private static final Vector3D LOOK = Vector3D.plusK;
    private static final Vector3D UP = Vector3D.plusJ;
    private final PApplet p;
    private final double startDistance;
    private final Vector3D startCenter;
    private boolean resetOnDoubleClick = true;
    private double minimumDistance = 1.0;
    private double maximumDistance = Double.MAX_VALUE;
    private final DampedAction rotateX;
    private final DampedAction rotateY;
    private final DampedAction rotateZ;
    private double distance;
    private Vector3D center;
    private Rotation rotation;
    private Constraint dragConstraint = null;
    private final InterpolationManager rotationInterps = new InterpolationManager();
    private final InterpolationManager centerInterps = new InterpolationManager();
    private final InterpolationManager distanceInterps = new InterpolationManager();
    private final PeasyDragHandler panHandler;
    private PeasyDragHandler centerDragHandler = this.panHandler = new PeasyDragHandler(){

        public void handleDrag(double dx, double dy) {
            PeasyCam.this.mousePan(dx, dy);
        }
    };
    private final PeasyDragHandler rotateHandler;
    private PeasyDragHandler leftDragHandler = this.rotateHandler = new PeasyDragHandler(){

        public void handleDrag(double dx, double dy) {
            PeasyCam.this.mouseRotate(dx, dy);
        }
    };
    private final PeasyDragHandler zoomHandler;
    private PeasyDragHandler rightDraghandler = this.zoomHandler = new PeasyDragHandler(){

        public void handleDrag(double dx, double dy) {
            PeasyCam.this.mouseZoom(dy);
        }
    };
    private final PMatrix3D originalMatrix = new PMatrix3D();
    public final String VERSION = "0.7.0";

    public PeasyCam(PApplet parent, double distance) {
        this(parent, 0.0, 0.0, 0.0, distance);
    }

    public PeasyCam(PApplet parent, double lookAtX, double lookAtY, double lookAtZ, double distance) {
        this.p = parent;
        this.startCenter = this.center = new Vector3D(lookAtX, lookAtY, lookAtZ);
        this.startDistance = this.distance = distance;
        this.rotation = new Rotation();
        parent.getMatrix(this.originalMatrix);
        this.feed();
        this.rotateX = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusI, velocity));
            }
        };
        this.rotateY = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusJ, velocity));
            }
        };
        this.rotateZ = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusK, velocity));
            }
        };
        PeasyMouseListener mouseListener = new PeasyMouseListener();
        this.p.registerMouseEvent((Object)mouseListener);
        this.p.registerKeyEvent((Object)mouseListener);
        System.err.println("PeasyCam v0.7.0");
    }

    public void setMouseControlled(boolean isMouseControlled) {
        if (isMouseControlled) {
            this.leftDragHandler = this.rotateHandler;
            this.rightDraghandler = this.zoomHandler;
            this.centerDragHandler = this.panHandler;
        } else {
            this.leftDragHandler = null;
            this.rightDraghandler = null;
            this.centerDragHandler = null;
        }
    }

    public PeasyDragHandler getPanDragHandler() {
        return this.panHandler;
    }

    public PeasyDragHandler getRotateDragHandler() {
        return this.rotateHandler;
    }

    public PeasyDragHandler getZoomDragHandler() {
        return this.zoomHandler;
    }

    public void setLeftDragHandler(PeasyDragHandler handler) {
        this.leftDragHandler = handler;
    }

    public void setCenterDragHandler(PeasyDragHandler handler) {
        this.centerDragHandler = handler;
    }

    public void setRightDragHandler(PeasyDragHandler handler) {
        this.rightDraghandler = handler;
    }

    public String version() {
        return "0.7.0";
    }

    private void mouseZoom(double delta) {
        this.safeSetDistance(this.distance + delta * Math.sqrt(this.distance * 0.2));
    }

    private void mousePan(double dxMouse, double dyMouse) {
        double panScale = Math.sqrt(this.distance * 0.005);
        this.pan(this.dragConstraint == Constraint.Y ? 0.0 : -dxMouse * panScale, this.dragConstraint == Constraint.X ? 0.0 : -dyMouse * panScale);
    }

    private void mouseRotate(double dx, double dy) {
        Vector3D vz;
        Vector3D u = LOOK.scalarMultiply(100.0 + 0.6 * this.startDistance).negate();
        if (this.dragConstraint != Constraint.X) {
            double rho = Math.abs((double)this.p.width / 2.0 - (double)this.p.mouseX) / ((double)this.p.width / 2.0);
            double adz = Math.abs(dy) * rho;
            double ady = Math.abs(dy) * (1.0 - rho);
            int ySign = dy < 0.0 ? -1 : 1;
            Vector3D vy = u.add(new Vector3D(0.0, ady, 0.0));
            this.rotateX.impulse(Vector3D.angle(u, vy) * (double)ySign);
            vz = u.add(new Vector3D(0.0, adz, 0.0));
            this.rotateZ.impulse(Vector3D.angle(u, vz) * (double)(-ySign) * (double)(this.p.mouseX < this.p.width / 2 ? -1 : 1));
        }
        if (this.dragConstraint != Constraint.Y) {
            double eccentricity = Math.abs((double)this.p.height / 2.0 - (double)this.p.mouseY) / ((double)this.p.height / 2.0);
            int xSign = dx > 0.0 ? -1 : 1;
            double adz = Math.abs(dx) * eccentricity;
            double adx = Math.abs(dx) * (1.0 - eccentricity);
            Vector3D vx = u.add(new Vector3D(adx, 0.0, 0.0));
            this.rotateY.impulse(Vector3D.angle(u, vx) * (double)xSign);
            vz = u.add(new Vector3D(0.0, adz, 0.0));
            this.rotateZ.impulse(Vector3D.angle(u, vz) * (double)xSign * (double)(this.p.mouseY > this.p.height / 2 ? -1 : 1));
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double newDistance) {
        this.setDistance(newDistance, 300L);
    }

    public void setDistance(double newDistance, long animationTimeMillis) {
        this.distanceInterps.startInterpolation(new DistanceInterp(newDistance, animationTimeMillis));
    }

    public float[] getLookAt() {
        return new float[]{(float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ()};
    }

    public void lookAt(double x, double y, double z) {
        this.centerInterps.startInterpolation(new CenterInterp(new Vector3D(x, y, z), 300L));
    }

    public void lookAt(double x, double y, double z, double distance) {
        this.lookAt(x, y, z);
        this.setDistance(distance);
    }

    public void lookAt(double x, double y, double z, long animationTimeMillis) {
        this.lookAt(x, y, z, this.distance, animationTimeMillis);
    }

    public void lookAt(double x, double y, double z, double distance, long animationTimeMillis) {
        this.setState(new CameraState(this.rotation, new Vector3D(x, y, z), distance), animationTimeMillis);
    }

    private void safeSetDistance(double distance) {
        this.distance = Math.min(this.maximumDistance, Math.max(this.minimumDistance, distance));
        this.feed();
    }

    public void feed() {
        Vector3D pos = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        Vector3D rup = this.rotation.applyTo(UP);
        this.p.camera((float)pos.getX(), (float)pos.getY(), (float)pos.getZ(), (float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ(), (float)rup.getX(), (float)rup.getY(), (float)rup.getZ());
    }

    public float[] getPosition() {
        Vector3D pos = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        return new float[]{(float)pos.getX(), (float)pos.getY(), (float)pos.getZ()};
    }

    public void reset() {
        this.reset(300L);
    }

    public void reset(long animationTimeInMillis) {
        this.setState(new CameraState(new Rotation(), this.startCenter, this.startDistance), animationTimeInMillis);
    }

    public void pan(double dx, double dy) {
        this.center = this.center.add(this.rotation.applyTo(new Vector3D(dx, dy, 0.0)));
        this.feed();
    }

    public void rotateX(double angle) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusI, angle));
        this.feed();
    }

    public void rotateY(double angle) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusJ, angle));
        this.feed();
    }

    public void rotateZ(double angle) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusK, angle));
        this.feed();
    }

    PApplet getApplet() {
        return this.p;
    }

    public CameraState getState() {
        return new CameraState(this.rotation, this.center, this.distance);
    }

    public void setMinimumDistance(double minimumDistance) {
        this.minimumDistance = minimumDistance;
        this.safeSetDistance(this.distance);
    }

    public void setMaximumDistance(double maximumDistance) {
        this.maximumDistance = maximumDistance;
        this.safeSetDistance(this.distance);
    }

    public void setResetOnDoubleClick(boolean resetOnDoubleClick) {
        this.resetOnDoubleClick = resetOnDoubleClick;
    }

    public void setState(CameraState state) {
        this.setState(state, 300L);
    }

    public void setState(CameraState state, long animationTimeMillis) {
        if (animationTimeMillis > 0L) {
            this.rotationInterps.startInterpolation(new RotationInterp(state.rotation, animationTimeMillis));
            this.centerInterps.startInterpolation(new CenterInterp(state.center, animationTimeMillis));
            this.distanceInterps.startInterpolation(new DistanceInterp(state.distance, animationTimeMillis));
        } else {
            this.rotation = state.rotation;
            this.center = state.center;
            this.distance = state.distance;
        }
        this.feed();
    }

    public void setRotations(double pitch, double yaw, double roll) {
        this.rotationInterps.cancelInterpolation();
        this.rotation = new Rotation(RotationOrder.XYZ, pitch, yaw, roll);
        this.feed();
    }

    public float[] getRotations() {
        try {
            double[] angles = this.rotation.getAngles(RotationOrder.XYZ);
            return new float[]{(float)angles[0], (float)angles[1], (float)angles[2]};
        }
        catch (CardanEulerSingularityException angles) {
            try {
                double[] angles2 = this.rotation.getAngles(RotationOrder.YXZ);
                return new float[]{(float)angles2[1], (float)angles2[0], (float)angles2[2]};
            }
            catch (CardanEulerSingularityException angles2) {
                try {
                    double[] angles3 = this.rotation.getAngles(RotationOrder.ZXY);
                    return new float[]{(float)angles3[2], (float)angles3[0], (float)angles3[1]};
                }
                catch (CardanEulerSingularityException cardanEulerSingularityException) {
                    return new float[]{0.0f, 0.0f, 0.0f};
                }
            }
        }
    }

    public void beginHUD() {
        this.p.pushMatrix();
        this.p.hint(4);
        this.p.resetMatrix();
        this.p.applyMatrix(this.originalMatrix);
    }

    public void endHUD() {
        this.p.hint(-4);
        this.p.popMatrix();
    }

    public abstract class AbstractInterp {
        double startTime;
        final double timeInMillis;

        protected AbstractInterp(long timeInMillis) {
            this.timeInMillis = timeInMillis;
        }

        void start() {
            this.startTime = PeasyCam.this.p.millis();
            PeasyCam.this.p.registerDraw((Object)this);
        }

        void cancel() {
            PeasyCam.this.p.unregisterDraw((Object)this);
        }

        public void draw() {
            double t = ((double)PeasyCam.this.p.millis() - this.startTime) / this.timeInMillis;
            if (t > 0.99) {
                this.cancel();
                this.setEndState();
            } else {
                this.interp(t);
            }
            PeasyCam.this.feed();
        }

        protected abstract void interp(double var1);

        protected abstract void setEndState();
    }

    class CenterInterp
    extends AbstractInterp {
        private final Vector3D startCenter;
        private final Vector3D endCenter;

        public CenterInterp(Vector3D endCenter, long timeInMillis) {
            super(timeInMillis);
            this.startCenter = PeasyCam.this.center;
            this.endCenter = endCenter;
        }

        protected void interp(double t) {
            PeasyCam.this.center = InterpolationUtil.smooth(this.startCenter, this.endCenter, t);
        }

        protected void setEndState() {
            PeasyCam.this.center = this.endCenter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Constraint {
        X,
        Y;

    }

    class DistanceInterp
    extends AbstractInterp {
        private final double startDistance;
        private final double endDistance;

        public DistanceInterp(double endDistance, long timeInMillis) {
            super(timeInMillis);
            this.startDistance = PeasyCam.this.distance;
            this.endDistance = Math.min(PeasyCam.this.maximumDistance, Math.max(PeasyCam.this.minimumDistance, endDistance));
        }

        protected void interp(double t) {
            PeasyCam.this.distance = InterpolationUtil.smooth(this.startDistance, this.endDistance, t);
        }

        protected void setEndState() {
            PeasyCam.this.distance = this.endDistance;
        }
    }

    protected class PeasyMouseListener {
        protected PeasyMouseListener() {
        }

        public void keyEvent(KeyEvent e) {
            if (e.getID() == 402 && e.getKeyCode() == 16) {
                PeasyCam.this.dragConstraint = null;
            }
        }

        public void mouseEvent(MouseEvent e) {
            if (PeasyCam.this.resetOnDoubleClick && e.getID() == 500 && e.getClickCount() == 2) {
                PeasyCam.this.reset();
            } else if (e.getID() == 502) {
                PeasyCam.this.dragConstraint = null;
            } else if (e.getID() == 506) {
                double dx = ((PeasyCam)PeasyCam.this).p.mouseX - ((PeasyCam)PeasyCam.this).p.pmouseX;
                double dy = ((PeasyCam)PeasyCam.this).p.mouseY - ((PeasyCam)PeasyCam.this).p.pmouseY;
                if (e.isShiftDown()) {
                    if (PeasyCam.this.dragConstraint == null && Math.abs(dx - dy) > 1.0) {
                        PeasyCam.this.dragConstraint = Math.abs(dx) > Math.abs(dy) ? Constraint.X : Constraint.Y;
                    }
                } else {
                    PeasyCam.this.dragConstraint = null;
                }
                int b = ((PeasyCam)PeasyCam.this).p.mouseButton;
                if (PeasyCam.this.centerDragHandler != null && (b == 3 || b == 37 && e.isMetaDown())) {
                    PeasyCam.this.centerDragHandler.handleDrag(dx, dy);
                } else if (PeasyCam.this.leftDragHandler != null && b == 37) {
                    PeasyCam.this.leftDragHandler.handleDrag(dx, dy);
                } else if (PeasyCam.this.rightDraghandler != null && b == 39) {
                    PeasyCam.this.rightDraghandler.handleDrag(dx, dy);
                }
            }
        }
    }

    class RotationInterp
    extends AbstractInterp {
        final Rotation startRotation;
        final Rotation endRotation;

        public RotationInterp(Rotation endRotation, long timeInMillis) {
            super(timeInMillis);
            this.startRotation = PeasyCam.this.rotation;
            this.endRotation = endRotation;
        }

        void start() {
            PeasyCam.this.rotateX.stop();
            PeasyCam.this.rotateY.stop();
            PeasyCam.this.rotateZ.stop();
            super.start();
        }

        protected void interp(double t) {
            PeasyCam.this.rotation = InterpolationUtil.slerp(this.startRotation, this.endRotation, t);
        }

        protected void setEndState() {
            PeasyCam.this.rotation = this.endRotation;
        }
    }
}

