

import peasy.org.apache.commons.math.geometry.*;

void drawMolecule(AtomSetCollection asc, boolean pick,float id) {
//print("id"+id);
//print("pick"+pick);
  // center molecule
  String jojojo;
  if(reset) {
    xmin=+MAX_FLOAT; ymin=+MAX_FLOAT; zmin=+MAX_FLOAT;
    xmax=-MAX_FLOAT; ymax=-MAX_FLOAT; zmax=-MAX_FLOAT;
    for(int i=0; i<asc.getAtomCount(); i++)  {
      org.jmol.adapter.smarter.Atom a = asc.getAtom(i);
      xmin = min(xmin, a.x); ymin = min(ymin, a.y); zmin = min(zmin, a.z);
      xmax = max(xmax, a.x); ymax = max(ymax, a.y); zmax = max(zmax, a.z); 
      
    }
    dx = (xmax+xmin)/2; dy = (ymax+ymin)/2; dz = (zmax+zmin)/2;
    dmax = max(max(xmax-xmin, ymax-ymin), zmax-zmin);
    reset = false;
  }
  
  // draw molecule
  
  scale(1,-1); // flip y-axis
  scale(width/dmax);
  translate(-dx, -dy, -dz);
  rt = sqrt(ra*ra - rb*rb); // tube offset;
int bjojo;  
  // draw bonds
  for(int i=0; i<asc.getBondCount(); i++) {
     org.jmol.adapter.smarter.Bond b = asc.getBond(i);
     org.jmol.adapter.smarter.Atom a1 = asc.getAtom(b.atomIndex1);
     org.jmol.adapter.smarter.Atom a2 = asc.getAtom(b.atomIndex2);
     org.jmol.adapter.smarter.Atom a3 = asc.getAtom(b.order);
     bjojo =b.order;
     
      // print(bjojo);
     if(bjojo==1)
     {
     fill(cb, transparent ? opacity : 255);
     tube(a1.x, a1.y, a1.z, a2.x, a2.y, a2.z, rb); 
     }
     if(bjojo==2)
     {
     fill(b2, transparent ? opacity : 255);
     dobletube(a1.x, a1.y, a1.z, a2.x, a2.y, a2.z, rb); 
     }
     if(bjojo==3)
     {
     fill(b3, transparent ? opacity : 255);
     tripletube(a1.x, a1.y, a1.z, a2.x, a2.y, a2.z, rb); 
     }   
  }

  // draw atoms  
  for(int i=0; i<asc.getAtomCount(); i++)  {
    
    org.jmol.adapter.smarter.Atom a = asc.getAtom(i);
    jojojo=a.getElementSymbol();
    picker.start(i);
    
  //    print(jojojo);
    pushMatrix();
    translate(a.x, a.y, a.z);
    if(jojojo=="H")
    fill(ch, transparent ? opacity : 255);
    if(jojojo=="C")
    fill(ca, transparent ? opacity : 255);
     if(jojojo=="O")
    fill(o1, transparent ? opacity : 255);
    //if(i==id && pick==true ){
    //fill(o1, transparent ? opacity : 255);
   // }
    sphere(ra);
   // pick=false;
    popMatrix();
    
  }
  
  for(int i=0; i<asc.getAtomCount(); i++)  {
  //  picker.start(i);
  //print(i);
 // print("id"+id+"\n");
  //print("pick"+pick);
    org.jmol.adapter.smarter.Atom a = asc.getAtom(i);
     //    print(jojojo);
  if( pick==true&& id==i){
    //print("jojojo");
    pushMatrix();
    translate(a.x, a.y, a.z);
    
  
     fill(ch, transparent ? opacity : 255);
    
    sphere(ra);
    //pick=false;
    popMatrix();
  }
  }
  

}


// draw a tube between two points

void dobletube(float x1, float y1, float z1, float x2, float y2, float z2, float r) {
  float d = dist(x1, y1, z1, x2, y2, z2);
  if (2*rt > d) return;
  pushMatrix();
  translate(x1, y1, z1);
  Rotation rot = new Rotation(new Vector3D(0, 0, 1), new Vector3D(x2-x1, y2-y1, z2-z1));
  beginShape(QUAD_STRIP);
  for(int i=0; i<=detail; i++) {
    float a = i * TWO_PI / detail;
    float x = r * cos(a);
    float y = r * sin(a);
    rvertex((x/4)+0.1, (y/4)+0.1, d - rt, rot);
    rvertex((x/4)+0.1, (y/4)+0.1, rt, rot);
      
  }
  endShape(CLOSE);
  
  beginShape(QUAD_STRIP);
  for(int i=0; i<=detail; i++) {
    float a = i * TWO_PI / detail;
    float x = r * cos(a);
    float y = r * sin(a);
    rvertex((x/4)-0.1, (y/4)-0.1, d - rt, rot);
    rvertex((x/4)-0.1, (y/4)-0.1, rt, rot);
    
    
  }
  endShape(CLOSE);
  
  
  
  popMatrix();
}


void tube(float x1, float y1, float z1, float x2, float y2, float z2, float r) {
  float d = dist(x1, y1, z1, x2, y2, z2);
  if (2*rt > d) return;
  pushMatrix();
  translate(x1, y1, z1);
  Rotation rot = new Rotation(new Vector3D(0, 0, 1), new Vector3D(x2-x1, y2-y1, z2-z1));
  beginShape(QUAD_STRIP);
  for(int i=0; i<=detail; i++) {
    float a = i * TWO_PI / detail;
    float x = r * cos(a);
    float y = r * sin(a);
    rvertex(x, y, d - rt, rot);
    rvertex(x, y, rt, rot);
  }
  endShape(CLOSE);
  popMatrix();
}

void tripletube(float x1, float y1, float z1, float x2, float y2, float z2, float r) {
  float d = dist(x1, y1, z1, x2, y2, z2);
  if (2*rt > d) return;
  pushMatrix();
  translate(x1, y1, z1);
  Rotation rot = new Rotation(new Vector3D(0, 0, 1), new Vector3D(x2-x1, y2-y1, z2-z1));
  beginShape(QUAD_STRIP);
  for(int i=0; i<=detail; i++) {
    float a = i * TWO_PI / detail;
    float x = r * cos(a);
    float y = r * sin(a);
    rvertex((x/4)+0.1, (y/4)+0.1, d - rt, rot);
    rvertex((x/4)+0.1, (y/4)+0.1, rt, rot);
      
  }
  endShape(CLOSE);
  
  beginShape(QUAD_STRIP);
  for(int i=0; i<=detail; i++) {
    float a = i * TWO_PI / detail;
    float x = r * cos(a);
    float y = r * sin(a);
    rvertex((x/4)-0.1, (y/4)-0.1, d - rt, rot);
    rvertex((x/4)-0.1, (y/4)-0.1, rt, rot);
    
    
  }
  endShape(CLOSE);
  
  beginShape(QUAD_STRIP);
  for(int i=0; i<=detail; i++) {
    float a = i * TWO_PI / detail;
    float x = r * cos(a);
    float y = r * sin(a);
    rvertex((x/4)-0.0, (y/4)-0.0, d - rt, rot);
    rvertex((x/4)-0.0, (y/4)-0.0, rt, rot);
    
    
  }
  endShape(CLOSE);
  
  
  
  popMatrix();
}

// rotated vertices
void rvertex(float x, float y, float z, Rotation rot) {
  Vector3D v = rot.applyTo(new Vector3D(x,y,z));
  vertex((float)v.getX(), (float)v.getY(), (float)v.getZ());
}

// nice lighting
void lights() {
  int w=120, m=-1, p=+1;
  ambientLight(w,w,w);
  directionalLight(w, w, w, m, m, m);
  directionalLight(w, w, w, p, p, p);
  directionalLight(w, w, w, m, m, p);
  directionalLight(w, w, w, p, p, m); 
}

