/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class AnalogRemote
extends VRPNDevice
implements Runnable {
    public static final int MAX_CHANNELS = 128;
    protected static final Object notifyingChangeListenersLock = new Object();
    protected Vector changeListeners = new Vector();

    public AnalogRemote(String string, String string2, String string3, String string4, String string5) throws InstantiationException {
        super(string, string2, string3, string4, string5);
    }

    public synchronized native int getNumActiveChannels();

    public int getMaxActiveChannels() {
        return 128;
    }

    public synchronized void addAnalogChangeListener(AnalogChangeListener analogChangeListener) {
        this.changeListeners.addElement(analogChangeListener);
    }

    public synchronized boolean removeAnalogChangeListener(AnalogChangeListener analogChangeListener) {
        return this.changeListeners.removeElement(analogChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAnalogChange(long l, long l2, double[] dArray) {
        Object object = notifyingChangeListenersLock;
        synchronized (object) {
            AnalogUpdate analogUpdate = new AnalogUpdate();
            analogUpdate.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            analogUpdate.channel = (double[])dArray.clone();
            Enumeration enumeration = this.changeListeners.elements();
            while (enumeration.hasMoreElements()) {
                AnalogChangeListener analogChangeListener = (AnalogChangeListener)enumeration.nextElement();
                analogChangeListener.analogUpdate(analogUpdate, this);
            }
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownAnalog();

    @Override
    protected native void mainloop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.changeListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownAnalog();
        }
    }

    public static interface AnalogChangeListener {
        public void analogUpdate(AnalogUpdate var1, AnalogRemote var2);
    }

    public class AnalogUpdate {
        public Date msg_time = new Date();
        public double[] channel;
    }
}

