/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class AuxiliaryLoggerRemote
extends VRPNDevice
implements Runnable {
    protected Vector listeners = new Vector();
    protected static final Object notifyingListenersLock = new Object();

    public AuxiliaryLoggerRemote(String string) throws InstantiationException {
        super(string, null, null, null, null);
    }

    public synchronized native boolean sendLoggingRequest(String var1, String var2, String var3, String var4);

    public synchronized native boolean sendLoggingStatusRequest();

    public synchronized void addLoggingReportListener(LoggingReportListener loggingReportListener) {
        this.listeners.addElement(loggingReportListener);
    }

    public synchronized boolean removeLoggingReportListener(LoggingReportListener loggingReportListener) {
        return this.listeners.removeElement(loggingReportListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLoggingReport(long l, long l2, String string, String string2, String string3, String string4) {
        Object object = notifyingListenersLock;
        synchronized (object) {
            LoggingReport loggingReport = new LoggingReport();
            loggingReport.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            loggingReport.localInLogfileName = string;
            loggingReport.localOutLogfileName = string2;
            loggingReport.remoteInLogfileName = string3;
            loggingReport.remoteOutLogfileName = string4;
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                LoggingReportListener loggingReportListener = (LoggingReportListener)enumeration.nextElement();
                loggingReportListener.loggingReport(loggingReport, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.listeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownAuxiliaryLogger();
        }
    }

    protected native void shutdownAuxiliaryLogger();

    @Override
    protected native void mainloop();

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    public static interface LoggingReportListener {
        public void loggingReport(LoggingReport var1, AuxiliaryLoggerRemote var2);
    }

    public class LoggingReport {
        public Date msg_time = new Date();
        public String localInLogfileName = "";
        public String localOutLogfileName = "";
        public String remoteInLogfileName = "";
        public String remoteOutLogfileName = "";
    }
}

