import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

import vrpn.AnalogRemote;
import vrpn.AnalogRemote.AnalogChangeListener;
import vrpn.AnalogRemote.AnalogUpdate;
import vrpn.TrackerRemote;
import vrpn.TrackerRemote.PositionChangeListener;
import vrpn.TrackerRemote.TrackerUpdate;
import vrpn.TrackerRemote.VelocityChangeListener;
import vrpn.TrackerRemote.VelocityUpdate;
import vrpn.TrackerRemoteListener;

public class Cliente implements PositionChangeListener,
		AnalogChangeListener, VelocityChangeListener {
	public Socket conexion;
	public PrintWriter out;
	private DatagramSocket socket;
	public ServerSocket server;

	private File archivo;
	private PrintWriter reader;

	private String buffer = "";
	private int contador;

	private long tiempoAnterior = 0;

	private ArrayList<ThreadConexion> threads;

	public Cliente() {
		threads = new ArrayList<ThreadConexion>();
		AnalogRemote track;
		try {

			TrackerRemote track2 = new TrackerRemote(
					"TrackerPhase@157.253.192.178", "", "", "", "");

			System.out.println(track2.isConnected());

			track2.addPositionChangeListener(this);

			/*
			 * track = new AnalogRemote("Mouse0@157.253.208.18", "", "", "",
			 * ""); track.addAnalogChangeListener(this);
			 * System.out.println(track.isConnected());
			 */

			/*
			 * archivo=new File("testKinect"+System.currentTimeMillis()+".txt");
			 * try { reader=new PrintWriter(archivo); } catch
			 * (FileNotFoundException e1) { // TODO Auto-generated catch block
			 * e1.printStackTrace(); }
			 */
			try {
				server = new ServerSocket(40001);

				new Thread() {
					public void run() {
						try {
							while (true) {
								Socket conexion = server.accept();
								// System.out.println(conexion.getSendBufferSize());
								ThreadConexion t = new ThreadConexion(conexion);
								threads.add(t);
								t.start();
								if (threads.size() > 1) {
									threads.get(0).stop();
									threads.remove(0);
								}
								System.out.println("Recibio conexion");
							}
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}.start();

			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static void main(String args[]) {
		new Cliente();
	}

	/*
	 * Kinect con Blender
	 * 
	 * @Override public void trackerPositionUpdate(TrackerUpdate arg0,
	 * TrackerRemote arg1) {
	 * System.out.println("Kinect: "+arg0.sensor+" "+arg0.pos
	 * [0]+" "+arg0.pos[1]); if(out!=null) if(contador>20) { out.print(buffer);
	 * contador=0; buffer=""; } else { contador++;
	 * buffer+=(buffer.equals("")?"#"
	 * :"")+arg0.sensor+";"+arg0.pos[0]+";"+arg0.pos[1]+";"+arg0.pos[2]+"#"; }
	 * if(arg0.sensor==15) {
	 * //reader.println(arg0.sensor+";"+arg0.pos[0]+";"+arg0
	 * .pos[1]+";"+arg0.pos[2]); }
	 * 
	 * }
	 */

	@Override
	public void trackerPositionUpdate(TrackerUpdate arg0, TrackerRemote arg1) {

		String buffer = arg0.sensor + ";" + arg0.pos[0] + ";" + arg0.pos[1]
				+ ";" + arg0.pos[2] + ";" + arg0.quat[0] + ";" + arg0.quat[1]
				+ ";" + arg0.quat[2] + ";" + arg0.quat[3] + "#";
		System.out.println(buffer);
		for (ThreadConexion t : threads) {
			t.agregarBuffer(buffer);
			// System.out.println(buffer);
		}

	}

	@Override
	public void analogUpdate(AnalogUpdate arg0, AnalogRemote arg1) {
		// System.out.println(""+arg0.channel[0]+";"+arg0.channel[1]+";0;0;0;0;0;0#");
		if (out != null) {
			if (contador > 5) {
				out.print(buffer);
				out.flush();
				contador = 0;
				buffer = "";
			} else {
				contador++;
				buffer += "" + arg0.channel[0] + ";" + arg0.channel[1]
						+ ";0;0;0;0;0;0#";
			}
		}

	}

	@Override
	public void trackerVelocityUpdate(VelocityUpdate arg0, TrackerRemote arg1) {
		// System.out.println(arg0.vel);

	}

}
