//
//  TouchControl.m
//  FollowFinger
//
//  Created by Luis Ballesteros on 5/5/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "TouchControl.h"
#import "iMove3DAppDelegate.h"
#import "RunnerViewController.h"

@implementation TouchControl
{
    iMove3DAppDelegate *_iMove3DAppDelegate;
    RunnerViewController *_runnerViewController;
    BOOL isLongPress;
}
//@synthesize numberOfTaps;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
        
    }
    return self;
}


- (void) touchesBegan:(NSSet*)touches withEvent:(UIEvent*)event 
{
    
    int ct = [[touches anyObject] tapCount];
    //NSLog(@"Taps: %d",ct);
    if (ct == 1) 
    {
        if(isLongPress)
        {
            _iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
            _iMove3DAppDelegate.isLongPressed = TRUE;
        }
        
    }
    if (ct == 2) {
        [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(singleTap) object:nil];
    }
    if (ct == 3) {
        [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(doubleTap) object:nil];
    }
    //_iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
	// Retrieve the touch point
	//startPoint = [[touches anyObject] locationInView:self];
    //_iMove3DAppDelegate.startPoint=startPoint;
    //NSLog(@"BEGIN 1 - X:%f - Y:%f",startPoint.x,startPoint.y);
	
}
- (void) touchesMoved:(NSSet*)touches withEvent:(UIEvent*)event 
{
    NSUInteger touchCount = 0;
    UITouch* touch; 
    CGPoint point1;
    CGPoint point2;
    
    for (touch in touches) 
    {
        touchCount++;
    }
    
    // When multiple touches, report the number of touches. 
    if (touchCount == 1) 
    {
        //NSLog(@"Tracking 1 touch");
        point1 = [[touches anyObject] previousLocationInView: self.superview];
        point2 = [[touches anyObject] locationInView:self];
        [self dispatchOneTouchEvent:point1 toPosition2:point2];
    } 
    else if (touchCount == 2)
    {
        //NSLog(@"Tracking 2 touches", touchCount);
        point1 = [[touches anyObject] previousLocationInView: self.superview];
        point2 = [[touches anyObject] locationInView:self];
        [self dispatchTwoTouchEvent:point1 toPosition2:point2];
    }
    
    // Move relative to the original touch point
    //currentPoint = [[touches anyObject] locationInView:self];
    //startPoint = [[touches anyObject] previousLocationInView: self.superview];
    //NSLog(@"MOVING - X:%f - Y:%f",delta_X,delta_Y);    
    //Load the delegat to comunicate the two points
}

-(void)dispatchOneTouchEvent:(CGPoint)point1 toPosition2:(CGPoint)point2
{
    _iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
    _iMove3DAppDelegate.numberOfTouches = 1;
    _iMove3DAppDelegate.startPoint=point1;
    _iMove3DAppDelegate.currentPoint=point2;
    NSLog(@"MOVING - X:%f - Y:%f",point1.x,point1.y); 
    
}

-(void)dispatchTwoTouchEvent:(CGPoint)point1 toPosition2:(CGPoint)point2
{
    _iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
    _iMove3DAppDelegate.numberOfTouches = 2;
    _iMove3DAppDelegate.startPoint=point1;
    _iMove3DAppDelegate.currentPoint=point2;
    
}

- (void) touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    _iMove3DAppDelegate.currentPoint=currentPoint;
    _iMove3DAppDelegate.startPoint=currentPoint;
    
    int ct = [[touches anyObject] tapCount];
    if (ct == 1)
        [self performSelector:@selector(singleTap) withObject:nil afterDelay:0.3]; 
    if (ct == 2)
        [self performSelector:@selector(doubleTap) withObject:nil afterDelay:0.3]; 
    if (ct == 3)
        [self tripleTap];
    _iMove3DAppDelegate.isLongPressed = FALSE;
    
}

-(void)touchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event
{
    _iMove3DAppDelegate.currentPoint=currentPoint;
    _iMove3DAppDelegate.startPoint=currentPoint;
    _iMove3DAppDelegate.isLongPressed = FALSE;
}

     

- (void) singleTap {
    //NSLog(@"single tap"); 
    _iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
    _iMove3DAppDelegate.numberOfTaps=1;
    [_iMove3DAppDelegate changeStatePointingDragging];
    _iMove3DAppDelegate.isLongPressed = FALSE;
}

- (void) doubleTap {
    //NSLog(@"double tap"); 
    _iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
    _iMove3DAppDelegate.numberOfTaps=2;
    [_iMove3DAppDelegate changeStateTranslatingRotating];
    _iMove3DAppDelegate.isLongPressed = FALSE;
}

- (void) tripleTap {
    //NSLog(@"triple tap"); 
    _iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];
    _iMove3DAppDelegate.numberOfTaps=3;
    [_iMove3DAppDelegate changeStateGyroTouching];
    _iMove3DAppDelegate.isLongPressed = FALSE;
}


#pragma mark Gesture Functions
/*-(void)addGestures
{
    UILongPressGestureRecognizer *longPress = [[UILongPressGestureRecognizer alloc]
                                               initWithTarget:self 
                                               action:@selector(handleLongPress:)];
    CFTimeInterval *iItemLongPressTime = [;
    longPress.minimumPressDuration = iItemLongPressTime;
    [self addGestureRecognizer:longPress];
    //[longPress release];
}*/

- (IBAction)longPressed : (UILongPressGestureRecognizer *) recognizer
{
    if (recognizer.state == UIGestureRecognizerStateEnded) {
        NSLog(@"Long press Ended");
        isLongPress = FALSE;
    }
    else {
        NSLog(@"Long press Detected");
        //if (self.isSelected) return;
        
        //if ([delegate respondsToSelector:@selector(singleTouch:)])
        //    [delegate singleTouch:self];
        
        //[recognizer removeTarget:self action:@selector(handleLongPress:)];
        //recognizer.enabled = NO;
        //[self removeGestureRecognizer:recognizer];
        isLongPress = TRUE;
    }
    
    //_iMove3DAppDelegate = (iMove3DAppDelegate *)[[UIApplication sharedApplication] delegate];

    //NSLog(@"Long Press");
    
}

/*
 // Only override drawRect: if you perform custom drawing.
 // An empty implementation adversely affects performance during animation.
 - (void)drawRect:(CGRect)rect
 {
 // Drawing code
 }
 */



@end
