//
//  iMove3DViewController.m
//  iMove3Dv4
//
//  Created by Luis Ballesteros on 5/6/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "iMove3DViewController.h"
#import "iMove3DAppDelegate.h"
#import "RunnerViewController.h"

@interface iMove3DViewController (){
    //Host
    NSString *host;
    //Port
    int port;
    //sample frecuency
    float sampleFrecuency;
    //Transmission Speed
    float transSpeed;
    //sensitivity
    float sensitivity;
}

@end

@implementation iMove3DViewController
@synthesize addressField;
@synthesize portField;
@synthesize sampFrecuencyLabel;
@synthesize transSpeedLabel;
@synthesize sensitivityLabel;


- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    //sampleFrecuency = 60.0;
    //self.sampFrecuencyLabel.text = @"60";

}

- (void)viewDidUnload
{
    [self setAddressField:nil];
    [self setPortField:nil];
    [self setSampFrecuencyLabel:nil];
    [self setSampFrecuencyLabel:nil];
    [self setSensitivityLabel:nil];
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

/*- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
    } else {
        return YES;
    }
}*/

- (IBAction)sampFrecuencySlider:(id)sender {
    UISlider *slider = (UISlider *) sender;
    sampleFrecuency = (float)(slider.value);
    //NSLog(@"%f",sampleFrecuency);
    NSString *cell2val = [NSString stringWithFormat:@"%2.0f",sampleFrecuency];
    sampFrecuencyLabel.text = cell2val;
}

- (IBAction)transSpeedSlider:(id)sender {
    UISlider *slider = (UISlider *) sender;
    transSpeed = (float)(slider.value);
    //NSLog(@"%f",transSpeed);
    NSString *cell2val = [NSString stringWithFormat:@"%2.0f",transSpeed];
    transSpeedLabel.text = cell2val;   
}

- (IBAction)sensitivitySlider:(id)sender {
    UISlider *slider = (UISlider *) sender;
    sensitivity = (float)(slider.value);
    //NSLog(@"%f",sensitivity);
    NSString *cell2val = [NSString stringWithFormat:@"%2.1f",sensitivity];
    sensitivityLabel.text = cell2val;   
}



- (IBAction)runButton:(id)sender {
    //Validate Host
	host = addressField.text;
	if ([host length] == 0)
	{
        UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"Address Error!"
                                                        message:@"Enter a valid URL or IP Address"
                                                       delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [alert show];
        //[self logError:@"Address required"];
		return;
	}
    //Validate Port	
	port = [portField.text intValue];
	if (port <= 0 || port > 65535)
	{
        UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"Port Error!"
                                                        message:@"Enter a valid UDP socket port"
                                                       delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [alert show];
        
		//[self logError:@"Valid port required"];
		return;
	}
    //Get the delegate instance
    iMove3DAppDelegate* iMove3Ddelegate = (iMove3DAppDelegate*)[[UIApplication sharedApplication] delegate];

    //Assign the URL value to the delegate propery
    iMove3Ddelegate.url = addressField.text;

    //Assign the port value to the delegate propery
    iMove3Ddelegate.port = portField.text;

    //Assign the sampleing frecuency value to the delegate propery
    iMove3Ddelegate.sampFrecuency = sampFrecuencyLabel.text;

    //Assign the transmision speed value to the delegate propery
    iMove3Ddelegate.transSpeed = transSpeedLabel.text;

    //Assign the sensitivity value to the delegate propery
    iMove3Ddelegate.sensitivity = sensitivityLabel.text;

    //Get the instance of the runner view controller
    RunnerViewController *vc= [self.storyboard instantiateViewControllerWithIdentifier:@"runnerViewCont"];
    //Configure the transition
    vc.definesPresentationContext = YES; 
    vc.providesPresentationContextTransitionStyle = YES; 
    vc.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
    vc.modalPresentationStyle = UIModalPresentationCurrentContext;
    //Show the runner view controller
    [self presentViewController:vc animated:YES completion:nil];
}


- (BOOL)textFieldShouldReturn: (UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}

- (void)touchesEnded: (NSSet *)touches withEvent: (UIEvent *)event {
    for (UIView* view in self.view.subviews) {
        if ([view isKindOfClass:[UITextField class]])
            [view resignFirstResponder];
    }
}

@end
