using UnityEngine;

using System;
using System.Collections;
using System.Runtime.InteropServices;

/// <summary>
/// Static class used to call all dll methods
/// </summary>
public class iOSDevice : MonoBehaviour
{
	/// <summary>
	/// Setup iOS device data (set the vrpn's device name, and channels for pitch and yaw angle)
	/// </summary>
	/// <param name='deviceName'>
	/// Device name.
	/// </param>
    /// <param name='buttonsChannel'>
    /// buttons channel.
    /// </param>
    /// <param name='deltaXChannel'>
	/// deltaX channel.
	/// </param>
	/// <param name='deltaYChannel'>
	/// deltaY channel.
    /// </param>
    /// <param name='deltaZChannel'>
    /// deltaZ channel.
    /// </param>
	/// <param name='yawChannel'>
	/// Yaw channel.
	/// </param>
	/// <param name='pitchChannel'>
	/// Pitch channel.
    /// </param>
    /// <param name='rollChannel'>
    /// Roll channel.
	/// </param>
    [DllImport("VRPNDLLClient")]
    public static extern void VRPNDLLClient_SetupDevice(string deviceName, int buttonsChannel, int yawChannel, int pitchChannel, int rollChannel, int deltaXChannel, int deltaYChannel, int deltaZChannel);
	
    /// <summary>
    /// Start the device thread
    /// </summary>
    [DllImport("VRPNDLLClient")]
    public static extern void VRPNDLLClient_StartDevice();
	
    /// <summary>
    /// Stop the device thread
    /// </summary>
    [DllImport("VRPNDLLClient")]
    public static extern void VRPNDLLClient_StopDevice();
	
    /// <summary>
    /// Read actual device orientation and if it is firing
    [DllImport("VRPNDLLClient")]
    public static extern void VRPNDLLClient_ReadDevice(out DeviceValues deviceValues);
}
