﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Microsoft.Kinect;
using System.Windows.Threading;
using System.Threading;

namespace Kinect_CameraControl
{
    /// <summary>
    /// Interaction logic for HelpWindow.xaml
    /// </summary>
    public partial class HelpWindow : Window
    {

        # region Private State
        /// <summary>
        /// The Kinect.
        /// </summary>
        public KinectSensor sensor;

        /// <summary>
        /// Current step.
        /// </summary>
        public int step = 1;

        /// <summary>
        /// Current frame beneath the step.
        /// </summary>
        public int frame = 1;

        /// <summary>
        /// Flag. Controls when the help thread shoould stop.
        /// </summary>
        bool runningHelpThread;
        #endregion Private State

        #region ctor + Window Events
        public HelpWindow()
        {
            InitializeComponent();

            updateHelpImg();
            //Start the help thread.
            Thread helpThread = new Thread(this.HelpThread);
            helpThread.Start();
        }

        /// <summary>
        /// On close, stop the help thread.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            runningHelpThread = false;
        }

        /// <summary>
        /// Set the actual sensor to the color view.
        /// </summary>
        /// <param name="nSensor"></param>
        public void setSensor(KinectSensor nSensor)
        {
            sensor = nSensor;
            kinectColorViewer1.Kinect = sensor;
        }

        /// <summary>
        /// Next step.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void image2_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            step++;
            if (step > 6)
            {
                step = 1;
            }
            frame = 1;
            updateHelpImg();
        }

        /// <summary>
        /// Previous step.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void image3_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            step--;
            if (step <= 0)
            {
                step = 6;
            }
            frame = 1;
            updateHelpImg();
        }

        #endregion ctor + Window Events

        # region Help Thread and Update Image

        /// <summary>
        /// Updates the image that corresponds to the current step and frame.
        /// </summary>
        public void updateHelpImg()
        {
            BitmapImage helpImg = new BitmapImage();
            helpImg.BeginInit();
            helpImg.UriSource = new Uri("pack://application:,,,/Kinect_CameraControl;component/data/img/step"+step+"_"+frame+".png");
            helpImg.EndInit();
            image1.Source = helpImg;
        }

        /// <summary>
        /// This thread advances one frame each two seconds.
        /// </summary>
        private void HelpThread()
        {
            this.runningHelpThread = true;

            while (this.runningHelpThread)
            {
                Thread.Sleep(2000);
                frame++;
                if (frame > 4)
                {
                    step++;
                    if (step > 6)
                    {
                        step = 1;
                    }
                    frame = 1;
                }
                this.Dispatcher.Invoke(DispatcherPriority.Send, new Action<int>(this.HandleHelpTimer), 0);
            }
        }

        /// <summary>
        /// The handler updates the image. Must be invoked to gain control of the UI objects.
        /// </summary>
        /// <param name="param"></param>
        private void HandleHelpTimer(int param)
        {
            updateHelpImg();
        }

        #endregion Help Thread and Update Image

    }
}
