﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace Kinect_CameraControl
{
    public class Player
    {
        # region Private State

        /// <summary>
        /// Player id.
        /// </summary>
        private readonly int id;
        
        /// <summary>
        /// Player color.
        /// </summary>
        public int colorId { get; set; }

        /// <summary>
        /// Color definition for red.
        /// </summary>
        public Byte[] mixR = { 255, 255, 255, 0, 255, 0, 0 };

        /// <summary>
        /// Color definition for green.
        /// </summary>
        public Byte[] mixG = { 255, 255, 0, 255, 0, 255, 0 };

        /// <summary>
        /// Color definition for blue.
        /// </summary>
        public Byte[] mixB = { 255, 0, 255, 255, 0, 0, 255 };

        /// <summary>
        /// Player minimum depth.
        /// </summary>
        public double playerMinZ { get; set; }

        /// <summary>
        /// Player maximum depth.
        /// </summary>
        public double playerMaxZ { get; set; }

        /// <summary>
        /// Player is being tracked.
        /// </summary>
        public bool IsAlive { get; set; }

        /// <summary>
        /// Last time that the player was tracked.
        /// </summary>
        public DateTime LastUpdated { get; set; }

        #endregion Private State

        #region Ctor

        /// <summary>
        /// Player initialization.
        /// </summary>
        /// <param name="skeletonSlot"></param>
        public Player(int skeletonSlot)
        {
            this.id = skeletonSlot;
            this.LastUpdated = DateTime.Now;
            colorId = 0;
        }

        #endregion Ctor

        #region Color update + getId

        /// <summary>
        /// Change to the next color.
        /// </summary>
        public void changeColorUp()
        {
            colorId++;
            if (colorId > 6)
                colorId = 0;
        }

        /// <summary>
        /// Change to the previous color.
        /// </summary>
        public void changeColorDown()
        {
            colorId--;
            if (colorId < 0)
                colorId = 5;
        }

        /// <summary>
        /// Get id.
        /// </summary>
        public int GetId()
        {
            return this.id;
        }

        #endregion Color update + getId
    }
}
