
var _mainLight : GameObject;
var _mainCamera : GameObject;
var _sparks : GameObject;
var _burns : GameObject;
var _follower : GameObject;

var _xyRaw : Vector2 = Vector2.zero;
var _xyFixed : Vector2 = Vector2.zero;
var _xyMin : Vector2 = Vector2.zero;
var _xyMax : Vector2 = Vector2.zero;
var _xyPrevious : Vector2 = Vector2.zero;
var _xyDifference : Vector2 = Vector2.zero;


var _multiplier : float = 2.0;
var _smoothTime : float = 0.3;
var _followSpeed : float = 0.3;

private var _lightVelocity : float = 0.0;
private var _followerVelocity : Vector3 = Vector3.zero;


function Awake(){
mainCamera = GameObject.Find("MainCamera");
}

function OnTriggerEnter (other : Collider) {
    other.transform.gameObject.GetComponent(OrangeScript)._distanceDiference = _xyDifference;
    other.transform.gameObject.GetComponent(OrangeScript).Explode();
}

function Update () {
	_follower.transform.position = Vector3.SmoothDamp(_follower.transform.position, transform.position,
                                 _followerVelocity, _followSpeed);
	_xyRaw = Vector2(transform.position.x, transform.position.y);

	// Determinate the light follower
	var _newBrightness : float = Mathf.SmoothDamp(_mainLight.GetComponent(Light).intensity, Vector2.Distance(_xyRaw,_xyPrevious)*0.1,
                                 _lightVelocity, _smoothTime);
    _newBrightness = Mathf.Clamp(_newBrightness, 0.1,3.0);
    _mainLight.GetComponent(Light).intensity = _newBrightness;
    
    //Debug.Log(Vector2.Distance(_xyRaw, xyPrev));
    if(_newBrightness > 0.5){
		Instantiate(_burns, transform.position, transform.rotation);
		if(audio.isPlaying == false){
			audio.pitch = _newBrightness;
		audio.Play();
			}
		}
	_xyDifference = Vector2((_xyRaw.x-_xyPrevious.x)*_multiplier,(_xyRaw.y-_xyPrevious.y)*_multiplier);
	_xyPrevious = _xyRaw;
}