#include <math.h>
// DEFINICION DE PINES
const int xPin = 2; //acelerometro en X
const int yPin = 3; //acelerometro en Y
const int zPin = 5; //acelerometro en Z
const int ledPin = 13; //pin del led (board)
const int ledPinExt = 6; //pin del led externo
const int speakerPin = 9; //pin del speaker
const int buzzerPin = 10; //pin del buzzer
const int buzzerPin1 = 11; //pin del buzzer
const int limSleep = 50; //tiempo de espera antes de encender speaker
const int limLed = 10; ////tiempo de espera antes de encender led


//CALIBRACION DEL ACELEROMETRO
int minVal = 395; //valor minimo en estatico
int maxVal = 621; //valor maximo en estatico

//Valores de orientacion del  sensor
double x; // orientacion en x
double y; // orientacion en y
double z; // orientacion en z
int contSleep = 0; // contador para encender sonido

//FILTRO LECTURAS
const int filterSize = 50;
int xFilter[filterSize];
int yFilter[filterSize];
int zFilter[filterSize];
boolean filterInitialized = false;

//Configuración de la board
void setup(){
  pinMode(ledPin, OUTPUT); //configurar el pin para el led como salida
  pinMode(ledPinExt, OUTPUT); //configurar el pin para el led como salida
  pinMode(speakerPin, OUTPUT); //configurar el pin para el speaker como salida
  pinMode(buzzerPin, OUTPUT); //configurar el pin para el buzzer como salida
  pinMode(buzzerPin1, OUTPUT); //configurar el pin para el buzzer como salida
  Serial.begin(9600); //configurar la salida del puerto serial a 9600bps
}

//Ciclo que se ejecuta constantemente
void loop(){
  //leer los valores analogos de los sensores
  leerAcelerometro();  
  int xRead = leerX();
  int yRead = leerY();
  int zRead = leerZ();
  //Convertir los valores para que puedan ser calculados en el atan2
  int xAng = map(xRead, minVal, maxVal, -90, 90);
  int yAng = map(yRead, minVal, maxVal, -90, 90);
  int zAng = map(zRead, minVal, maxVal, -90, 90);
  //Calcula la orientación a 360°
  x = RAD_TO_DEG * (atan2(-yAng, -zAng) + PI);
  y = RAD_TO_DEG * (atan2(-xAng, -zAng) + PI);
  z = RAD_TO_DEG * (atan2(-yAng, -xAng) + PI);
  //Enviar la orientación por puerto serial
  Serial.print("Ang;");
  Serial.print(x);
  Serial.print(";");
  Serial.print(y);
  Serial.print(";");
  Serial.println(z);
  //Evaluar la orientación de la cabeza para ver si está despistado....
  if( (x>340 || x < 20) && (y>340 || y < 20) ) { 
    digitalWrite(ledPin, LOW); //apagar el pin
    digitalWrite(ledPinExt, LOW); //apagar el pin
    contSleep = 0;
  } else {
    if(contSleep > limLed) {
      digitalWrite(ledPin, HIGH); //encender el pin
      digitalWrite(ledPinExt, HIGH); //encender el pin
    }    
    if(contSleep > limSleep) { // si lleva más de determinado tiempo reproducir sonido...
      beep(speakerPin,3520,100); //Do durante 100ms 
    } else {
      contSleep ++;
    }
  }
}


void beep (unsigned char speakerPin, int frequencyInHertz, long timeInMilliseconds) {
  int x1;
  long delayAmount = (long)(1000000/frequencyInHertz);
  long loopTime = (long)((timeInMilliseconds*1000)/(delayAmount*2));
  for (x1=0;x1<loopTime;x1++){
      digitalWrite(speakerPin,HIGH);
      digitalWrite(buzzerPin,HIGH);
      delayMicroseconds(delayAmount);
      digitalWrite(speakerPin,LOW);
      digitalWrite(buzzerPin,LOW);
      delayMicroseconds(delayAmount);
  }
}


void leerAcelerometro() {
  int xRead = analogRead(xPin);
  int yRead = analogRead(yPin);
  int zRead = analogRead(zPin);  
  if(filterInitialized == false) {
    for(int i = 0; i < filterSize; i++) {
      xFilter[i] = xRead;
      yFilter[i] = yRead;
      zFilter[i] = zRead;
    }
  }else{
    int xtmp;
    int ytmp;
    int ztmp;
    for(int i = 0; i < filterSize; i++) {
      int tmp1;
      if(i==0) {
        //xread....
        xtmp = xFilter[0];
        xFilter[0] = xRead;
        //yread....
        ytmp = yFilter[0];
        yFilter[0] = yRead;
        //zread...
        ztmp = zFilter[0];
        zFilter[0] = zRead;
      }else{
        //xread...
        tmp1 = xFilter[i];
        xFilter[i]=xtmp;
        xtmp = tmp1;
        //yread...
        tmp1 = yFilter[i];
        yFilter[i]=ytmp;
        ytmp = tmp1;
        //zread...
        tmp1 = zFilter[i];
        zFilter[i]=ztmp;
        ztmp = tmp1;
      }
    }
  }
}

int leerX() {
  int suma = 0;
  for(int i = 0; i < filterSize; i++) {
    suma += xFilter[i];
  }
  return suma / filterSize;
}

int leerY() {
  int suma = 0;
  for(int i = 0; i < filterSize; i++) {
    suma += yFilter[i];
  }
  return suma / filterSize;
}

int leerZ() {
  int suma = 0;
  for(int i = 0; i < filterSize; i++) {
    suma += zFilter[i];
  }
  return suma / filterSize;
}



